/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnPartitioner;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsCombiner;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsReducer;
import org.apache.kylin.engine.mr.steps.FactDistinctHiveColumnsMapper;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactDistinctColumnsJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(FactDistinctColumnsJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_STATISTICS_ENABLED);
            options.addOption(OPTION_STATISTICS_OUTPUT);
            options.addOption(OPTION_STATISTICS_SAMPLING_PERCENT);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME);
            String statistics_enabled = this.getOptionValue(OPTION_STATISTICS_ENABLED);
            String statistics_output = this.getOptionValue(OPTION_STATISTICS_OUTPUT);
            String statistics_sampling_percent = this.getOptionValue(OPTION_STATISTICS_SAMPLING_PERCENT);
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            CubeManager cubeMgr = CubeManager.getInstance(kylinConfig);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeDesc cubeDesc = cube.getDescriptor();
            List<TblColRef> columnsNeedDict = cubeMgr.getAllDictColumnsOnFact(cubeDesc);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.name", segmentName);
            this.job.getConfiguration().set("statistics.enabled", statistics_enabled);
            this.job.getConfiguration().set("statistics.ouput", statistics_output);
            this.job.getConfiguration().set("statistics.sampling.percent", statistics_sampling_percent);
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job);
            this.setupMapper(cube.getSegment(segmentName, SegmentStatusEnum.NEW));
            this.setupReducer(output, "true".equalsIgnoreCase(statistics_enabled) ? columnsNeedDict.size() + 1 : columnsNeedDict.size());
            this.attachKylinPropsAndMetadata(cube, this.job.getConfiguration());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in FactDistinctColumnsJob", (Throwable)e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setupMapper(CubeSegment cubeSeg) throws IOException {
        IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(cubeSeg).getFlatTableInputFormat();
        flatTableInputFormat.configureJob(this.job);
        this.job.setMapperClass(FactDistinctHiveColumnsMapper.class);
        this.job.setCombinerClass(FactDistinctColumnsCombiner.class);
        this.job.setMapOutputKeyClass(Text.class);
        this.job.setMapOutputValueClass(Text.class);
    }

    private void setupReducer(Path output, int numberOfReducers) throws IOException {
        this.job.setReducerClass(FactDistinctColumnsReducer.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(Text.class);
        this.job.setPartitionerClass(FactDistinctColumnPartitioner.class);
        this.job.setNumReduceTasks(numberOfReducers);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
        this.job.getConfiguration().set("output.path", output.toString());
        this.deletePath(this.job.getConfiguration(), output);
    }

    public static void main(String[] args) throws Exception {
        FactDistinctColumnsJob job = new FactDistinctColumnsJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

