/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidReducer
extends KylinReducer<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(CuboidReducer.class);
    private String cubeName;
    private CubeDesc cubeDesc;
    private List<MeasureDesc> measuresDescs;
    private MeasureCodec codec;
    private MeasureAggregators aggs;
    private int counter;
    private int cuboidLevel;
    private boolean[] needAggr;
    private Object[] input;
    private Object[] result;
    private ByteBuffer valueBuf = ByteBuffer.allocate(0x100000);
    private Text outputValue = new Text();

    protected void setup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase();
        this.cuboidLevel = context.getConfiguration().getInt("cube.cuboid.level", 0);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cubeDesc = CubeManager.getInstance(config).getCube(this.cubeName).getDescriptor();
        this.measuresDescs = this.cubeDesc.getMeasures();
        this.codec = new MeasureCodec(this.measuresDescs);
        this.aggs = new MeasureAggregators(this.measuresDescs);
        this.input = new Object[this.measuresDescs.size()];
        this.result = new Object[this.measuresDescs.size()];
        this.needAggr = new boolean[this.measuresDescs.size()];
        if (this.cuboidLevel > 0) {
            for (int i = 0; i < this.measuresDescs.size(); ++i) {
                this.needAggr[i] = !this.measuresDescs.get(i).getFunction().getMeasureType().onlyAggrInBaseCuboid();
            }
        }
    }

    public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        this.aggs.reset();
        for (Text value : values) {
            this.codec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), this.input);
            if (this.cuboidLevel > 0) {
                this.aggs.aggregate(this.input, this.needAggr);
                continue;
            }
            this.aggs.aggregate(this.input);
        }
        this.aggs.collectStates(this.result);
        this.valueBuf.clear();
        this.codec.encode(this.result, this.valueBuf);
        this.outputValue.set(this.valueBuf.array(), 0, this.valueBuf.position());
        context.write((Object)key, (Object)this.outputValue);
        ++this.counter;
        if (this.counter % 100000 == 0) {
            logger.info("Handled " + this.counter + " records!");
        }
    }
}

