/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesSplitter;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCuboidMapperBase<KEYIN, VALUEIN>
extends KylinMapper<KEYIN, VALUEIN, Text, Text> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseCuboidMapperBase.class);
    public static final byte[] HIVE_NULL = Bytes.toBytes("\\N");
    public static final byte[] ONE = Bytes.toBytes("1");
    protected String cubeName;
    protected String segmentName;
    protected Cuboid baseCuboid;
    protected CubeInstance cube;
    protected CubeDesc cubeDesc;
    protected CubeSegment cubeSegment;
    protected List<byte[]> nullBytes;
    protected CubeJoinedFlatTableDesc intermediateTableDesc;
    protected String intermediateTableRowDelimiter;
    protected byte byteRowDelimiter;
    protected int counter;
    protected MeasureIngester<?>[] aggrIngesters;
    protected Map<TblColRef, Dictionary<String>> dictionaryMap;
    protected Object[] measures;
    protected byte[][] keyBytesBuf;
    protected BytesSplitter bytesSplitter;
    protected AbstractRowKeyEncoder rowKeyEncoder;
    protected MeasureCodec measureCodec;
    private int errorRecordCounter;
    protected Text outputKey = new Text();
    protected Text outputValue = new Text();
    private ByteBuffer valueBuf = ByteBuffer.allocate(0x100000);

    protected void setup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase();
        this.segmentName = context.getConfiguration().get("cube.segment.name");
        this.intermediateTableRowDelimiter = context.getConfiguration().get("cube.intermediate.table.row.delimiter", Character.toString('\u007f'));
        if (Bytes.toBytes(this.intermediateTableRowDelimiter).length > 1) {
            throw new RuntimeException("Expected delimiter byte length is 1, but got " + Bytes.toBytes(this.intermediateTableRowDelimiter).length);
        }
        this.byteRowDelimiter = Bytes.toBytes(this.intermediateTableRowDelimiter)[0];
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cube = CubeManager.getInstance(config).getCube(this.cubeName);
        this.cubeDesc = this.cube.getDescriptor();
        this.cubeSegment = this.cube.getSegment(this.segmentName, SegmentStatusEnum.NEW);
        long baseCuboidId = Cuboid.getBaseCuboidId(this.cubeDesc);
        this.baseCuboid = Cuboid.findById(this.cubeDesc, baseCuboidId);
        this.intermediateTableDesc = new CubeJoinedFlatTableDesc(this.cube.getDescriptor(), this.cubeSegment);
        this.bytesSplitter = new BytesSplitter(200, 16384);
        this.rowKeyEncoder = AbstractRowKeyEncoder.createInstance(this.cubeSegment, this.baseCuboid);
        this.measureCodec = new MeasureCodec(this.cubeDesc.getMeasures());
        this.measures = new Object[this.cubeDesc.getMeasures().size()];
        int colCount = this.cubeDesc.getRowkey().getRowKeyColumns().length;
        this.keyBytesBuf = new byte[colCount][];
        this.aggrIngesters = MeasureIngester.create(this.cubeDesc.getMeasures());
        this.dictionaryMap = this.cubeSegment.buildDictionaryMap();
        this.initNullBytes();
    }

    private void initNullBytes() {
        this.nullBytes = Lists.newArrayList();
        this.nullBytes.add(HIVE_NULL);
        String[] nullStrings = this.cubeDesc.getNullStrings();
        if (nullStrings != null) {
            for (String s : nullStrings) {
                this.nullBytes.add(Bytes.toBytes(s));
            }
        }
    }

    protected boolean isNull(byte[] v) {
        for (byte[] nullByte : this.nullBytes) {
            if (!Bytes.equals(v, nullByte)) continue;
            return true;
        }
        return false;
    }

    protected byte[] buildKey(SplittedBytes[] splitBuffers) {
        int[] rowKeyColumnIndexes = this.intermediateTableDesc.getRowKeyColumnIndexes();
        for (int i = 0; i < this.baseCuboid.getColumns().size(); ++i) {
            int index = rowKeyColumnIndexes[i];
            this.keyBytesBuf[i] = Arrays.copyOf(splitBuffers[index].value, splitBuffers[index].length);
            if (!this.isNull(this.keyBytesBuf[i])) continue;
            this.keyBytesBuf[i] = null;
        }
        return this.rowKeyEncoder.encode(this.keyBytesBuf);
    }

    private void buildValue(SplittedBytes[] splitBuffers) {
        for (int i = 0; i < this.measures.length; ++i) {
            this.measures[i] = this.buildValueOf(i, splitBuffers);
        }
        this.valueBuf.clear();
        this.measureCodec.encode(this.measures, this.valueBuf);
    }

    private Object buildValueOf(int idxOfMeasure, SplittedBytes[] splitBuffers) {
        MeasureDesc measure = this.cubeDesc.getMeasures().get(idxOfMeasure);
        FunctionDesc function = measure.getFunction();
        int[] colIdxOnFlatTable = this.intermediateTableDesc.getMeasureColumnIndexes()[idxOfMeasure];
        int paramCount = function.getParameterCount();
        String[] inputToMeasure = new String[paramCount];
        ParameterDesc param = function.getParameter();
        int colParamIdx = 0;
        int i = 0;
        while (i < paramCount) {
            String value = function.isCount() ? "1" : (param.isColumnType() ? this.getCell(colIdxOnFlatTable[colParamIdx++], splitBuffers) : param.getValue());
            inputToMeasure[i] = value;
            ++i;
            param = param.getNextParameter();
        }
        return this.aggrIngesters[idxOfMeasure].valueOf(inputToMeasure, measure, this.dictionaryMap);
    }

    private String getCell(int i, SplittedBytes[] splitBuffers) {
        byte[] bytes = Arrays.copyOf(splitBuffers[i].value, splitBuffers[i].length);
        if (this.isNull(bytes)) {
            return null;
        }
        return Bytes.toString(bytes);
    }

    protected void outputKV(Mapper.Context context) throws IOException, InterruptedException {
        this.intermediateTableDesc.sanityCheck(this.bytesSplitter);
        byte[] rowKey = this.buildKey(this.bytesSplitter.getSplitBuffers());
        this.outputKey.set(rowKey, 0, rowKey.length);
        this.buildValue(this.bytesSplitter.getSplitBuffers());
        this.outputValue.set(this.valueBuf.array(), 0, this.valueBuf.position());
        context.write((Object)this.outputKey, (Object)this.outputValue);
    }

    protected byte[][] convertUTF8Bytes(String[] row) throws UnsupportedEncodingException {
        byte[][] result = new byte[row.length][];
        for (int i = 0; i < row.length; ++i) {
            result[i] = row[i] == null ? HIVE_NULL : row[i].getBytes("UTF-8");
        }
        return result;
    }

    protected void handleErrorRecord(BytesSplitter bytesSplitter, Exception ex) throws IOException {
        logger.error("Insane record: " + bytesSplitter, (Throwable)ex);
        ++this.errorRecordCounter;
        if (this.errorRecordCounter > 100) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("", ex);
        }
    }
}

