/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.invertedindex;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.metadata.model.SegmentStatusEnum;

public class InvertedIndexPartitioner
extends Partitioner<LongWritable, ImmutableBytesWritable>
implements Configurable {
    private Configuration conf;
    private TableRecordInfo info;
    private TableRecord rec;

    public int getPartition(LongWritable key, ImmutableBytesWritable value, int numPartitions) {
        this.rec.setBytes(value.get(), value.getOffset(), value.getLength());
        return this.rec.getShard();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        try {
            KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
            IIManager mgr = IIManager.getInstance(config);
            IIInstance ii = mgr.getII(conf.get("ii.name"));
            IISegment seg = ii.getSegment(conf.get("ii.segment.name"), SegmentStatusEnum.NEW);
            this.info = new TableRecordInfo(seg);
            this.rec = this.info.createTableRecord();
        }
        catch (IOException e) {
            throw new RuntimeException("", e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }
}

