/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.invertedindex;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.metadata.model.SegmentStatusEnum;

public class InvertedIndexMapper<KEYIN>
extends KylinMapper<KEYIN, Object, LongWritable, Writable> {
    private TableRecordInfo info;
    private LongWritable outputKey;
    private IMRInput.IMRTableInputFormat flatTableInputFormat;

    protected void setup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        Configuration conf = context.getConfiguration();
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        IIManager mgr = IIManager.getInstance(config);
        IIInstance ii = mgr.getII(conf.get("ii.name"));
        IISegment seg = ii.getSegment(conf.get("ii.segment.name"), SegmentStatusEnum.NEW);
        this.info = new TableRecordInfo(seg);
        this.outputKey = new LongWritable();
        this.flatTableInputFormat = MRUtil.getBatchCubingInputSide(ii.getFirstSegment()).getFlatTableInputFormat();
    }

    public void map(KEYIN key, Object record, Mapper.Context context) throws IOException, InterruptedException {
        Writable writableRecord = (Writable)record;
        String[] row = this.flatTableInputFormat.parseMapperInput(writableRecord);
        String timestampString = row[this.info.getTimestampColumn()];
        this.outputKey.set(DateFormat.stringToMillis(timestampString));
        context.write((Object)this.outputKey, (Object)writableRecord);
    }
}

