/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.invertedindex;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.invertedindex.InvertedIndexMapper;
import org.apache.kylin.engine.mr.invertedindex.InvertedIndexPartitioner;
import org.apache.kylin.engine.mr.invertedindex.InvertedIndexReducer;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.invertedindex.IISegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(InvertedIndexJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_II_NAME);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String iiname = this.getOptionValue(OPTION_II_NAME);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            logger.info("Starting: " + this.job.getJobName());
            IIInstance ii = this.getII(iiname);
            short sharding = ii.getDescriptor().getSharding();
            this.setJobClasspath(this.job);
            this.setupMapper(ii.getFirstSegment());
            this.setupReducer(output, sharding);
            this.attachMetadata(ii);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private IIInstance getII(String iiName) {
        IIManager mgr = IIManager.getInstance(KylinConfig.getInstanceFromEnv());
        IIInstance ii = mgr.getII(iiName);
        if (ii == null) {
            throw new IllegalArgumentException("No Inverted Index found by name " + iiName);
        }
        return ii;
    }

    private void attachMetadata(IIInstance ii) throws IOException {
        Configuration conf = this.job.getConfiguration();
        this.attachKylinPropsAndMetadata(ii, conf);
        IISegment seg = ii.getFirstSegment();
        conf.set("ii.name", ii.getName());
        conf.set("ii.segment.name", seg.getName());
    }

    private void setupMapper(IISegment segment) throws IOException {
        IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(segment).getFlatTableInputFormat();
        flatTableInputFormat.configureJob(this.job);
        this.job.setMapperClass(InvertedIndexMapper.class);
        this.job.setMapOutputKeyClass(LongWritable.class);
        this.job.setPartitionerClass(InvertedIndexPartitioner.class);
    }

    private void setupReducer(Path output, short sharding) throws IOException {
        this.job.setReducerClass(InvertedIndexReducer.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        this.job.setOutputKeyClass(ImmutableBytesWritable.class);
        this.job.setOutputValueClass(ImmutableBytesWritable.class);
        this.job.setNumReduceTasks((int)sharding);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
        this.job.getConfiguration().set("output.path", output.toString());
        this.deletePath(this.job.getConfiguration(), output);
    }

    public static void main(String[] args) throws Exception {
        InvertedIndexJob job = new InvertedIndexJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

