/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCmdOutput {
    protected static final Logger logger = LoggerFactory.getLogger(HadoopCmdOutput.class);
    private final StringBuilder output;
    private final Job job;
    private String mapInputRecords;
    private String hdfsBytesWritten;
    private String hdfsBytesRead;

    public HadoopCmdOutput(Job job, StringBuilder output) {
        this.job = job;
        this.output = output;
    }

    public String getMrJobId() {
        return this.getInfo().get("mr_job_id");
    }

    public Map<String, String> getInfo() {
        if (this.job != null) {
            HashMap<String, String> status = new HashMap<String, String>();
            if (null != this.job.getJobID()) {
                status.put("mr_job_id", this.job.getJobID().toString());
            }
            if (null != this.job.getTrackingURL()) {
                status.put("yarn_application_tracking_url", this.job.getTrackingURL().toString());
            }
            return status;
        }
        return Collections.emptyMap();
    }

    public String getMapInputRecords() {
        return this.mapInputRecords;
    }

    public String getHdfsBytesWritten() {
        return this.hdfsBytesWritten;
    }

    public String getHdfsBytesRead() {
        return this.hdfsBytesRead;
    }

    public void updateJobCounter() {
        try {
            Counters counters = this.job.getCounters();
            if (counters == null) {
                String errorMsg = "no counters for job " + this.getMrJobId();
                logger.warn(errorMsg);
                this.output.append(errorMsg);
                return;
            }
            this.output.append(counters.toString()).append("\n");
            logger.debug(counters.toString());
            this.mapInputRecords = String.valueOf(counters.findCounter((Enum)TaskCounter.MAP_INPUT_RECORDS).getValue());
            this.hdfsBytesWritten = String.valueOf(counters.findCounter("FileSystemCounters", "HDFS_BYTES_WRITTEN").getValue());
            this.hdfsBytesRead = String.valueOf(counters.findCounter("FileSystemCounters", "HDFS_BYTES_READ").getValue());
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.output.append(e.getLocalizedMessage());
        }
    }
}

