/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.BaseCuboidJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.InMemCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidJob;
import org.apache.kylin.engine.mr.steps.SaveStatisticsStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCubingJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchCubingJobBuilder2.class);
    private final IMRInput.IMRBatchCubingInputSide inputSide;
    private final IMROutput2.IMRBatchCubingOutputSide2 outputSide;

    public BatchCubingJobBuilder2(CubeSegment newSegment, String submitter) {
        super(newSegment, submitter);
        this.inputSide = MRUtil.getBatchCubingInputSide(this.seg);
        this.outputSide = MRUtil.getBatchCubingOutputSide2((CubeSegment)this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to BUILD segment " + this.seg);
        CubingJob result = CubingJob.createBuildJob((CubeSegment)this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        result.addTask(this.createFactDistinctColumnsStepWithStats(jobId));
        result.addTask(this.createBuildDictionaryStep(jobId));
        result.addTask(this.createSaveStatisticsStep(jobId));
        this.addOtherStepBeforeCubing(result);
        this.outputSide.addStepPhase2_BuildDictionary(result);
        this.addLayerCubingSteps(result, jobId, cuboidRootPath);
        result.addTask(this.createInMemCubingStep(jobId, cuboidRootPath));
        this.outputSide.addStepPhase3_BuildCube(result, cuboidRootPath);
        result.addTask(this.createUpdateCubeInfoAfterBuildStep(jobId));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    private void addLayerCubingSteps(CubingJob result, String jobId, String cuboidRootPath) {
        RowKeyDesc rowKeyDesc = ((CubeSegment)this.seg).getCubeDesc().getRowkey();
        int groupRowkeyColumnsCount = ((CubeSegment)this.seg).getCubeDesc().getBuildLevel();
        int totalRowkeyColumnsCount = rowKeyDesc.getRowKeyColumns().length;
        String[] cuboidOutputTempPath = this.getCuboidOutputPaths(cuboidRootPath, totalRowkeyColumnsCount, groupRowkeyColumnsCount);
        result.addTask(this.createBaseCuboidStep(cuboidOutputTempPath, jobId));
        for (int i = 1; i <= groupRowkeyColumnsCount; ++i) {
            int dimNum = totalRowkeyColumnsCount - i;
            result.addTask(this.createNDimensionCuboidStep(cuboidOutputTempPath, dimNum, totalRowkeyColumnsCount, jobId));
        }
    }

    private SaveStatisticsStep createSaveStatisticsStep(String jobId) {
        SaveStatisticsStep result = new SaveStatisticsStep();
        result.setName("Save Cuboid Statistics");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setStatisticsPath(this.getStatisticsPath(jobId), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    protected void addOtherStepBeforeCubing(CubingJob result) {
    }

    private MapReduceExecutable createInMemCubingStep(String jobId, String cuboidRootPath) {
        MapReduceExecutable cubeStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, "inmem", ((CubeSegment)this.seg).getCubeDesc().getModel());
        cubeStep.setName("Build Cube");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentname", this.seg.getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidRootPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Cube_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        cubeStep.setMapReduceParams(cmd.toString());
        cubeStep.setMapReduceJobClass(InMemCuboidJob.class);
        cubeStep.setCounterSaveAs("sourceRecordCount,sourceSizeBytes,byteSizeBytes");
        return cubeStep;
    }

    private MapReduceExecutable createBaseCuboidStep(String[] cuboidOutputTempPath, String jobId) {
        MapReduceExecutable baseCuboidStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, ((CubeSegment)this.seg).getCubeDesc().getModel());
        baseCuboidStep.setName("Build Base Cuboid Data");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentname", this.seg.getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "input", "FLAT_TABLE");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidOutputTempPath[0]);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Base_Cuboid_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "level", "0");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        baseCuboidStep.setMapReduceParams(cmd.toString());
        baseCuboidStep.setMapReduceJobClass(BaseCuboidJob.class);
        baseCuboidStep.setCounterSaveAs("sourceRecordCount,sourceSizeBytes");
        return baseCuboidStep;
    }

    private MapReduceExecutable createNDimensionCuboidStep(String[] cuboidOutputTempPath, int dimNum, int totalRowkeyColumnCount, String jobId) {
        MapReduceExecutable ndCuboidStep = new MapReduceExecutable();
        ndCuboidStep.setName("Build N-Dimension Cuboid Data : " + dimNum + "-Dimension");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, ((CubeSegment)this.seg).getCubeDesc().getModel());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentname", this.seg.getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "input", cuboidOutputTempPath[totalRowkeyColumnCount - dimNum - 1]);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidOutputTempPath[totalRowkeyColumnCount - dimNum]);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_ND-Cuboid_Builder_" + this.seg.getRealization().getName() + "_Step");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "level", "" + (totalRowkeyColumnCount - dimNum));
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        ndCuboidStep.setMapReduceParams(cmd.toString());
        ndCuboidStep.setMapReduceJobClass(NDCuboidJob.class);
        return ndCuboidStep;
    }
}

