/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.BaseCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCubingJobBuilder
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchCubingJobBuilder.class);
    private final IMRInput.IMRBatchCubingInputSide inputSide;
    private final IMROutput.IMRBatchCubingOutputSide outputSide;

    public BatchCubingJobBuilder(CubeSegment newSegment, String submitter) {
        super(newSegment, submitter);
        Preconditions.checkArgument((!newSegment.isEnableSharding() ? 1 : 0) != 0, (Object)"V1 job engine does not support building sharded cubes");
        this.inputSide = MRUtil.getBatchCubingInputSide(this.seg);
        this.outputSide = MRUtil.getBatchCubingOutputSide((CubeSegment)this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V1 new job to BUILD segment " + this.seg);
        CubingJob result = CubingJob.createBuildJob((CubeSegment)this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        result.addTask(this.createFactDistinctColumnsStep(jobId));
        result.addTask(this.createBuildDictionaryStep(jobId));
        RowKeyDesc rowKeyDesc = ((CubeSegment)this.seg).getCubeDesc().getRowkey();
        int groupRowkeyColumnsCount = ((CubeSegment)this.seg).getCubeDesc().getBuildLevel();
        int totalRowkeyColumnsCount = rowKeyDesc.getRowKeyColumns().length;
        String[] cuboidOutputTempPath = this.getCuboidOutputPaths(cuboidRootPath, totalRowkeyColumnsCount, groupRowkeyColumnsCount);
        result.addTask(this.createBaseCuboidStep(cuboidOutputTempPath, jobId));
        for (int i = 1; i <= groupRowkeyColumnsCount; ++i) {
            int dimNum = totalRowkeyColumnsCount - i;
            result.addTask(this.createNDimensionCuboidStep(cuboidOutputTempPath, dimNum, totalRowkeyColumnsCount));
        }
        this.outputSide.addStepPhase3_BuildCube(result, cuboidRootPath);
        result.addTask(this.createUpdateCubeInfoAfterBuildStep(jobId));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    private MapReduceExecutable createBaseCuboidStep(String[] cuboidOutputTempPath, String jobId) {
        MapReduceExecutable baseCuboidStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, ((CubeSegment)this.seg).getCubeDesc().getModel());
        baseCuboidStep.setName("Build Base Cuboid Data");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "segmentname", this.seg.getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "input", "FLAT_TABLE");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "output", cuboidOutputTempPath[0]);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "jobname", "Kylin_Base_Cuboid_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "level", "0");
        baseCuboidStep.setMapReduceParams(cmd.toString());
        baseCuboidStep.setMapReduceJobClass(BaseCuboidJob.class);
        baseCuboidStep.setCounterSaveAs("sourceRecordCount,sourceSizeBytes");
        return baseCuboidStep;
    }

    private MapReduceExecutable createNDimensionCuboidStep(String[] cuboidOutputTempPath, int dimNum, int totalRowkeyColumnCount) {
        MapReduceExecutable ndCuboidStep = new MapReduceExecutable();
        ndCuboidStep.setName("Build N-Dimension Cuboid Data : " + dimNum + "-Dimension");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, ((CubeSegment)this.seg).getCubeDesc().getModel());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "segmentname", this.seg.getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "input", cuboidOutputTempPath[totalRowkeyColumnCount - dimNum - 1]);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "output", cuboidOutputTempPath[totalRowkeyColumnCount - dimNum]);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "jobname", "Kylin_ND-Cuboid_Builder_" + this.seg.getRealization().getName() + "_Step");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "level", "" + (totalRowkeyColumnCount - dimNum));
        ndCuboidStep.setMapReduceParams(cmd.toString());
        ndCuboidStep.setMapReduceJobClass(NDCuboidJob.class);
        return ndCuboidStep;
    }
}

