/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedLenDimEnc
extends DimensionEncoding {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(FixedLenDimEnc.class);
    public static final byte ROWKEY_PLACE_HOLDER_BYTE = 9;
    public static final String ENCODING_NAME = "fixed_length";
    private int fixedLen;
    private transient int avoidVerbose = 0;

    public FixedLenDimEnc() {
    }

    public FixedLenDimEnc(int len) {
        this.fixedLen = len;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedLenDimEnc that = (FixedLenDimEnc)o;
        return this.fixedLen == that.fixedLen;
    }

    public int hashCode() {
        return this.fixedLen;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(byte[] value, int valueLen, byte[] output, int outputOffset) {
        if (value == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        if (valueLen > this.fixedLen && this.avoidVerbose++ % 10000 == 0) {
            logger.warn("Expect at most " + this.fixedLen + " bytes, but got " + valueLen + ", will truncate, value string: " + Bytes.toString(value, 0, valueLen) + " times:" + this.avoidVerbose);
        }
        int n = Math.min(valueLen, this.fixedLen);
        System.arraycopy(value, 0, output, outputOffset, n);
        if (n < this.fixedLen) {
            Arrays.fill(output, outputOffset + n, outputOffset + this.fixedLen, (byte)9);
        }
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        if (FixedLenDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        while (len > 0 && bytes[offset + len - 1] == 9) {
            --len;
        }
        return Bytes.toString(bytes, offset, len);
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new FixedLenSerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fixedLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readShort();
    }

    public class FixedLenSerializer
    extends DataTypeSerializer<Object> {
        private ThreadLocal<byte[]> current = new ThreadLocal();

        private byte[] currentBuf() {
            byte[] buf = this.current.get();
            if (buf == null) {
                buf = new byte[FixedLenDimEnc.this.fixedLen];
                this.current.set(buf);
            }
            return buf;
        }

        @Override
        public void serialize(Object value, ByteBuffer out) {
            byte[] buf = this.currentBuf();
            byte[] bytes = value == null ? null : Bytes.toBytes(value.toString());
            FixedLenDimEnc.this.encode(bytes, bytes == null ? 0 : bytes.length, buf, 0);
            out.put(buf);
        }

        @Override
        public Object deserialize(ByteBuffer in) {
            byte[] buf = this.currentBuf();
            in.get(buf);
            return FixedLenDimEnc.this.decode(buf, 0, buf.length);
        }

        @Override
        public int peekLength(ByteBuffer in) {
            return FixedLenDimEnc.this.fixedLen;
        }

        @Override
        public int maxLength() {
            return FixedLenDimEnc.this.fixedLen;
        }

        @Override
        public int getStorageBytesEstimate() {
            return FixedLenDimEnc.this.fixedLen;
        }

        @Override
        public Object valueOf(String str) {
            return str;
        }
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return FixedLenDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new FixedLenDimEnc(Integer.parseInt(args[0]));
        }
    }
}

