/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.FixedLenDimEnc;
import org.apache.kylin.dimension.IntegerDimEnc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DimensionEncodingFactory {
    private static final Logger logger = LoggerFactory.getLogger(DimensionEncodingFactory.class);
    private static Map<String, DimensionEncodingFactory> factoryMap;

    public static DimensionEncoding create(String encodingName, String[] args) {
        DimensionEncodingFactory factory;
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        if ((factory = factoryMap.get(encodingName)) == null) {
            throw new IllegalArgumentException("Unknown dimension encoding name " + encodingName + " (note '" + "dict" + "' is not handled by factory)");
        }
        return factory.createDimensionEncoding(encodingName, args);
    }

    public static Set<String> getValidEncodings() {
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        TreeSet result = Sets.newTreeSet();
        result.addAll(factoryMap.keySet());
        result.add("dict");
        return result;
    }

    public static boolean isVaildEncoding(String encodingName) {
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        return "dict".equals(encodingName) || factoryMap.containsKey(encodingName);
    }

    private static synchronized void initFactoryMap() {
        if (factoryMap == null) {
            String[] clsNames;
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fixed_length", new FixedLenDimEnc.Factory());
            map.put("int", new IntegerDimEnc.Factory());
            for (String clsName : clsNames = KylinConfig.getInstanceFromEnv().getCubeDimensionCustomEncodingFactories()) {
                try {
                    DimensionEncodingFactory factory = (DimensionEncodingFactory)ClassUtil.newInstance(clsName);
                    map.put(factory.getSupportedEncodingName(), factory);
                }
                catch (Exception ex) {
                    logger.error("Failed to init dimension encoding factory " + clsName, (Throwable)ex);
                }
            }
            factoryMap = map;
        }
    }

    public abstract String getSupportedEncodingName();

    public abstract DimensionEncoding createDimensionEncoding(String var1, String[] var2);
}

