/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.ReadableTable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SnapshotTable
extends RootPersistentEntity
implements ReadableTable {
    @JsonProperty(value="signature")
    private ReadableTable.TableSignature signature;
    @JsonProperty(value="useDictionary")
    private boolean useDictionary;
    private ArrayList<int[]> rowIndices;
    private Dictionary<String> dict;
    private static String NULL_STR;

    public SnapshotTable() {
        try {
            NULL_STR = new String(new byte[]{0, 9, 127, -1}, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    SnapshotTable(ReadableTable table) throws IOException {
        try {
            NULL_STR = new String(new byte[]{0, 9, 127, -1}, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.signature = table.getSignature();
        this.useDictionary = true;
    }

    public void takeSnapshot(ReadableTable table, TableDesc tableDesc) throws IOException {
        this.signature = table.getSignature();
        int maxIndex = tableDesc.getMaxColumnIndex();
        TrieDictionaryBuilder<String> b = new TrieDictionaryBuilder<String>(new StringBytesConverter());
        ReadableTable.TableReader reader = table.getReader();
        while (reader.next()) {
            Object[] row = reader.getRow();
            if (row.length <= maxIndex) {
                throw new IllegalStateException("Bad hive table row, " + tableDesc + " expect " + (maxIndex + 1) + " columns, but got " + Arrays.toString(row));
            }
            for (String string : row) {
                if (string == null) continue;
                b.addValue(string);
            }
        }
        this.dict = b.build(0);
        reader = table.getReader();
        ArrayList<int[]> allRowIndices = new ArrayList<int[]>();
        while (reader.next()) {
            String[] row = reader.getRow();
            int[] rowIndex = new int[row.length];
            for (int i = 0; i < row.length; ++i) {
                rowIndex[i] = this.dict.getIdFromValue(row[i]);
            }
            allRowIndices.add(rowIndex);
        }
        this.rowIndices = allRowIndices;
    }

    public String getResourcePath() {
        return "/table_snapshot/" + new File(this.signature.getPath()).getName() + "/" + this.uuid + ".snapshot";
    }

    public String getResourceDir() {
        return "/table_snapshot/" + new File(this.signature.getPath()).getName();
    }

    @Override
    public ReadableTable.TableReader getReader() throws IOException {
        return new ReadableTable.TableReader(){
            int i = -1;

            @Override
            public boolean next() throws IOException {
                ++this.i;
                return this.i < SnapshotTable.this.rowIndices.size();
            }

            @Override
            public String[] getRow() {
                int[] rowIndex = (int[])SnapshotTable.this.rowIndices.get(this.i);
                String[] row = new String[rowIndex.length];
                for (int x = 0; x < row.length; ++x) {
                    row[x] = (String)SnapshotTable.this.dict.getValueFromId(rowIndex[x]);
                }
                return row;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public ReadableTable.TableSignature getSignature() throws IOException {
        return this.signature;
    }

    @Override
    public int hashCode() {
        int[] parts = new int[this.rowIndices.size()];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = Arrays.hashCode(this.rowIndices.get(i));
        }
        return Arrays.hashCode(parts);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SnapshotTable)) {
            return false;
        }
        SnapshotTable that = (SnapshotTable)o;
        if (this.rowIndices.size() != that.rowIndices.size()) {
            return false;
        }
        for (int i = 0; i < this.rowIndices.size(); ++i) {
            if (ArrayUtils.isEquals((Object)this.rowIndices.get(i), (Object)that.rowIndices.get(i))) continue;
            return false;
        }
        return true;
    }

    void writeData(DataOutput out) throws IOException {
        block6: {
            out.writeInt(this.rowIndices.size());
            if (this.rowIndices.size() <= 0) break block6;
            int n = this.rowIndices.get(0).length;
            out.writeInt(n);
            if (this.useDictionary) {
                this.dict.write(out);
                for (int i = 0; i < this.rowIndices.size(); ++i) {
                    int[] row = this.rowIndices.get(i);
                    for (int j = 0; j < n; ++j) {
                        out.writeInt(row[j]);
                    }
                }
            } else {
                for (int i = 0; i < this.rowIndices.size(); ++i) {
                    int[] row = this.rowIndices.get(i);
                    for (int j = 0; j < n; ++j) {
                        out.writeUTF(this.dict.getValueFromId(row[j]) == null ? NULL_STR : this.dict.getValueFromId(row[j]));
                    }
                }
            }
        }
    }

    void readData(DataInput in) throws IOException {
        block9: {
            int rowNum = in.readInt();
            if (rowNum <= 0) break block9;
            int n = in.readInt();
            this.rowIndices = new ArrayList(rowNum);
            if (this.useDictionary) {
                this.dict = new TrieDictionary<String>();
                this.dict.readFields(in);
                for (int i = 0; i < rowNum; ++i) {
                    int[] row = new int[n];
                    this.rowIndices.add(row);
                    for (int j = 0; j < n; ++j) {
                        row[j] = in.readInt();
                    }
                }
            } else {
                ArrayList<String[]> rows = new ArrayList<String[]>(rowNum);
                TrieDictionaryBuilder<String> b = new TrieDictionaryBuilder<String>(new StringBytesConverter());
                for (int i = 0; i < rowNum; ++i) {
                    String[] row = new String[n];
                    rows.add(row);
                    for (int j = 0; j < n; ++j) {
                        row[j] = in.readUTF();
                        if (row[j].equals(NULL_STR)) {
                            row[j] = null;
                        }
                        b.addValue(row[j]);
                    }
                }
                this.dict = b.build(0);
                for (String[] row : rows) {
                    int[] rowIndex = new int[n];
                    for (int i = 0; i < n; ++i) {
                        rowIndex[i] = this.dict.getIdFromValue(row[i]);
                    }
                    this.rowIndices.add(rowIndex);
                }
            }
        }
    }
}

