/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.NumberDictionary;
import org.apache.kylin.dict.NumberDictionary2;
import org.apache.kylin.dict.TrieDictionaryBuilder;

public class NumberDictionaryBuilder<T>
extends TrieDictionaryBuilder<T> {
    NumberDictionary.NumberBytesCodec codec = new NumberDictionary.NumberBytesCodec(19);

    public NumberDictionaryBuilder(BytesConverter<T> bytesConverter) {
        super(bytesConverter);
    }

    @Override
    public void addValue(byte[] value) {
        this.codec.encodeNumber(value, 0, value.length);
        byte[] copy = Bytes.copy(this.codec.buf, this.codec.bufOffset, this.codec.bufLen);
        super.addValue(copy);
    }

    @Override
    public NumberDictionary<T> build(int baseId) {
        byte[] trieBytes = this.buildTrieBytes(baseId);
        NumberDictionary2 r = new NumberDictionary2(trieBytes);
        return r;
    }
}

