/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.dict.DateStrDictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.dict.MultipleDictionaryValueEnumerator;
import org.apache.kylin.dict.NumberDictionaryBuilder;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TableColumnValueEnumerator;
import org.apache.kylin.dict.TimeStrDictionary;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.source.ReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGenerator {
    private static final int DICT_MAX_CARDINALITY = DictionaryGenerator.getDictionaryMaxCardinality();
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGenerator.class);
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyyMMdd"};

    private static int getDictionaryMaxCardinality() {
        try {
            return KylinConfig.getInstanceFromEnv().getDictionaryMaxCardinality();
        }
        catch (Throwable e) {
            return 5000000;
        }
    }

    public static Dictionary<String> buildDictionaryFromValueEnumerator(DataType dataType, IDictionaryValueEnumerator valueEnumerator) throws IOException {
        Preconditions.checkNotNull((Object)dataType, (Object)"dataType cannot be null");
        int baseId = 0;
        int nSamples = 5;
        ArrayList samples = new ArrayList();
        Dictionary dict = dataType.isDateTimeFamily() ? (dataType.isDate() ? DictionaryGenerator.buildDateDict(valueEnumerator, baseId, nSamples, samples) : new TimeStrDictionary()) : (dataType.isNumberFamily() ? DictionaryGenerator.buildNumberDict(valueEnumerator, baseId, nSamples, samples) : DictionaryGenerator.buildStringDict(valueEnumerator, baseId, nSamples, samples));
        StringBuilder buf = new StringBuilder();
        for (Object s : samples) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(s.toString()).append("=>").append(dict.getIdFromValue(s));
        }
        logger.debug("Dictionary value samples: " + buf.toString());
        logger.debug("Dictionary cardinality " + dict.getSize());
        if (dict instanceof TrieDictionary && dict.getSize() > DICT_MAX_CARDINALITY) {
            throw new IllegalArgumentException("Too high cardinality is not suitable for dictionary -- cardinality: " + dict.getSize());
        }
        return dict;
    }

    public static Dictionary mergeDictionaries(DataType dataType, List<DictionaryInfo> sourceDicts) throws IOException {
        return DictionaryGenerator.buildDictionaryFromValueEnumerator(dataType, new MultipleDictionaryValueEnumerator(sourceDicts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary<String> buildDictionary(DictionaryInfo info, ReadableTable inpTable) throws IOException {
        try (IDictionaryValueEnumerator columnValueEnumerator = null;){
            logger.debug("Building dictionary object " + JsonUtil.writeValueAsString(info));
            columnValueEnumerator = new TableColumnValueEnumerator(inpTable.getReader(), info.getSourceColumnIndex());
            Dictionary<String> dictionary = DictionaryGenerator.buildDictionaryFromValueEnumerator(DataType.getType(info.getDataType()), columnValueEnumerator);
            return dictionary;
        }
    }

    private static Dictionary<String> buildDateDict(IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList samples) throws IOException {
        boolean BAD_THRESHOLD = false;
        String matchPattern = null;
        String[] arr$ = DATE_PATTERNS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String ptn;
            matchPattern = ptn = arr$[i$];
            int badCount = 0;
            SimpleDateFormat sdf = new SimpleDateFormat(ptn);
            while (valueEnumerator.moveNext()) {
                byte[] value = valueEnumerator.current();
                if (value == null || value.length == 0) continue;
                String str = Bytes.toString(value);
                try {
                    sdf.parse(str);
                    if (samples.size() >= nSamples || samples.contains(str)) continue;
                    samples.add(str);
                }
                catch (ParseException e) {
                    logger.info("Unrecognized date value: " + str);
                    if (++badCount <= 0) continue;
                    matchPattern = null;
                    break;
                }
            }
            if (matchPattern == null) continue;
            return new DateStrDictionary(matchPattern, baseId);
        }
        throw new IllegalStateException("Unrecognized datetime value");
    }

    private static Dictionary buildStringDict(IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList samples) throws IOException {
        TrieDictionaryBuilder<String> builder = new TrieDictionaryBuilder<String>(new StringBytesConverter());
        while (valueEnumerator.moveNext()) {
            byte[] value = valueEnumerator.current();
            if (value == null) continue;
            String v = Bytes.toString(value);
            builder.addValue(v);
            if (samples.size() >= nSamples || samples.contains(v)) continue;
            samples.add(v);
        }
        return builder.build(baseId);
    }

    private static Dictionary buildNumberDict(IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList samples) throws IOException {
        NumberDictionaryBuilder<String> builder = new NumberDictionaryBuilder<String>(new StringBytesConverter());
        while (valueEnumerator.moveNext()) {
            String v;
            byte[] value = valueEnumerator.current();
            if (value == null || StringUtils.isBlank((String)(v = Bytes.toString(value)))) continue;
            builder.addValue(v);
            if (samples.size() >= nSamples || samples.contains(v)) continue;
            samples.add(v);
        }
        return builder.build(baseId);
    }
}

