/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.IterableDictionaryValueEnumerator;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.ReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubingUtils {
    private static Logger logger = LoggerFactory.getLogger(CubingUtils.class);

    public static Map<Long, HyperLogLogPlusCounter> sampling(CubeDesc cubeDesc, Iterable<List<String>> streams) {
        CubeJoinedFlatTableDesc intermediateTableDesc = new CubeJoinedFlatTableDesc(cubeDesc, null);
        final int rowkeyLength = cubeDesc.getRowkey().getRowKeyColumns().length;
        List<Long> allCuboidIds = new CuboidScheduler(cubeDesc).getAllCuboidIds();
        final long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
        HashMap allCuboidsBitSet = Maps.newHashMap();
        Lists.transform(allCuboidIds, (Function)new Function<Long, Integer[]>(){

            @Nullable
            public Integer[] apply(@Nullable Long cuboidId) {
                Integer[] result = new Integer[Long.bitCount(cuboidId)];
                long mask = Long.highestOneBit(baseCuboidId);
                int position = 0;
                for (int i = 0; i < rowkeyLength; ++i) {
                    if ((mask & cuboidId) > 0L) {
                        result[position] = i;
                        ++position;
                    }
                    mask >>= 1;
                }
                return result;
            }
        });
        HashMap result = Maps.newHashMapWithExpectedSize((int)allCuboidIds.size());
        for (Long cuboidId : allCuboidIds) {
            result.put(cuboidId, new HyperLogLogPlusCounter(cubeDesc.getConfig().getCubeStatsHLLPrecision()));
            Integer[] cuboidBitSet = new Integer[Long.bitCount(cuboidId)];
            long mask = Long.highestOneBit(baseCuboidId);
            int position = 0;
            for (int i = 0; i < rowkeyLength; ++i) {
                if ((mask & cuboidId) > 0L) {
                    cuboidBitSet[position] = i;
                    ++position;
                }
                mask >>= 1;
            }
            allCuboidsBitSet.put(cuboidId, cuboidBitSet);
        }
        HashFunction hf = Hashing.murmur3_32();
        ByteArray[] row_hashcodes = new ByteArray[rowkeyLength];
        for (int i = 0; i < rowkeyLength; ++i) {
            row_hashcodes[i] = new ByteArray();
        }
        for (List<String> row : streams) {
            for (int i = 0; i < rowkeyLength; ++i) {
                Hasher hc = hf.newHasher();
                String cell = row.get(intermediateTableDesc.getRowKeyColumnIndexes()[i]);
                if (cell != null) {
                    row_hashcodes[i].set(hc.putString((CharSequence)cell).hash().asBytes());
                    continue;
                }
                row_hashcodes[i].set(hc.putInt(0).hash().asBytes());
            }
            for (Map.Entry longHyperLogLogPlusCounterEntry : result.entrySet()) {
                Long cuboidId = (Long)longHyperLogLogPlusCounterEntry.getKey();
                HyperLogLogPlusCounter counter = (HyperLogLogPlusCounter)longHyperLogLogPlusCounterEntry.getValue();
                Hasher hc = hf.newHasher();
                Integer[] cuboidBitSet = (Integer[])allCuboidsBitSet.get(cuboidId);
                for (int position = 0; position < cuboidBitSet.length; ++position) {
                    hc.putBytes(row_hashcodes[cuboidBitSet[position]].array());
                }
                counter.add(hc.hash().asBytes());
            }
        }
        return result;
    }

    public static Map<TblColRef, Dictionary<String>> buildDictionary(CubeInstance cubeInstance, Iterable<List<String>> recordList) throws IOException {
        List<TblColRef> columnsNeedToBuildDictionary = cubeInstance.getDescriptor().listDimensionColumnsExcludingDerived(true);
        HashMap tblColRefMap = Maps.newHashMap();
        int index = 0;
        for (TblColRef column : columnsNeedToBuildDictionary) {
            tblColRefMap.put(index++, column);
        }
        HashMap result = Maps.newHashMap();
        HashMultimap valueMap = HashMultimap.create();
        for (List<String> row : recordList) {
            for (int i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                if (!tblColRefMap.containsKey(i)) continue;
                valueMap.put(tblColRefMap.get(i), (Object)cell);
            }
        }
        for (TblColRef tblColRef : valueMap.keySet()) {
            Collection bytes = Collections2.transform((Collection)valueMap.get((Object)tblColRef), (Function)new Function<String, byte[]>(){

                @Nullable
                public byte[] apply(String input) {
                    return input == null ? null : input.getBytes();
                }
            });
            Dictionary<String> dict = DictionaryGenerator.buildDictionaryFromValueEnumerator(tblColRef.getType(), new IterableDictionaryValueEnumerator(bytes));
            result.put(tblColRef, dict);
        }
        return result;
    }

    public static Map<TblColRef, Dictionary<String>> writeDictionary(CubeSegment cubeSegment, Map<TblColRef, Dictionary<String>> dictionaryMap, long startOffset, long endOffset) {
        HashMap realDictMap = Maps.newHashMap();
        for (Map.Entry<TblColRef, Dictionary<String>> entry : dictionaryMap.entrySet()) {
            TblColRef tblColRef = entry.getKey();
            Dictionary<String> dictionary = entry.getValue();
            ReadableTable.TableSignature signature = new ReadableTable.TableSignature();
            signature.setLastModifiedTime(System.currentTimeMillis());
            signature.setPath(String.format("streaming_%s_%s", startOffset, endOffset));
            signature.setSize(endOffset - startOffset);
            DictionaryInfo dictInfo = new DictionaryInfo(tblColRef.getTable(), tblColRef.getName(), tblColRef.getColumnDesc().getZeroBasedIndex(), tblColRef.getDatatype(), signature);
            logger.info("writing dictionary for TblColRef:" + tblColRef.toString());
            DictionaryManager dictionaryManager = DictionaryManager.getInstance(cubeSegment.getCubeDesc().getConfig());
            try {
                DictionaryInfo realDict = dictionaryManager.trySaveNewDict(dictionary, dictInfo);
                cubeSegment.putDictResPath(tblColRef, realDict.getResourcePath());
                realDictMap.put(tblColRef, realDict.getDictionaryObject());
            }
            catch (IOException e) {
                throw new RuntimeException("error save dictionary for column:" + tblColRef, e);
            }
        }
        return realDictMap;
    }
}

