/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.upgrade.V1_5_1;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.cube.model.v1_4_0.CubeDesc;
import org.apache.kylin.cube.model.v1_4_0.DimensionDesc;
import org.apache.kylin.cube.model.v1_4_0.HBaseMappingDesc;
import org.apache.kylin.cube.model.v1_4_0.RowKeyColDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDescUpgrade_v_1_5_1 {
    private static final Logger logger = LoggerFactory.getLogger(CubeDescUpgrade_v_1_5_1.class);
    private static final Serializer<CubeDesc> oldCubeDescSerializer = new JsonSerializer<CubeDesc>(CubeDesc.class);
    private ResourceStore store;
    private String resourcePath;
    private List<String[]> oldHierarchies = Lists.newArrayList();
    private List<String> oldMandatories = Lists.newArrayList();
    private String[][] oldAggGroup = null;
    private Set<String> allRowKeyCols = this.newIgnoreCaseSet(null);

    public CubeDescUpgrade_v_1_5_1(String resourcePath, ResourceStore resourceStore) {
        this.resourcePath = resourcePath;
        this.store = resourceStore;
    }

    public org.apache.kylin.cube.model.CubeDesc upgrade() throws IOException {
        CubeDesc oldModel = this.loadOldCubeDesc(this.resourcePath);
        org.apache.kylin.cube.model.CubeDesc newModel = new org.apache.kylin.cube.model.CubeDesc();
        this.copyUnChangedProperties(oldModel, newModel);
        this.upgradeDimension(oldModel, newModel);
        this.upgradeRowKey(oldModel, newModel);
        this.upgradeHBaseMapping(oldModel, newModel);
        this.upgradeAggregationGroup(newModel);
        return newModel;
    }

    private CubeDesc loadOldCubeDesc(String path) throws IOException {
        CubeDesc ndesc = this.store.getResource(path, CubeDesc.class, oldCubeDescSerializer);
        if (StringUtils.isBlank((CharSequence)ndesc.getName())) {
            throw new IllegalStateException("CubeDesc name must not be blank");
        }
        return ndesc;
    }

    private Set<String> newIgnoreCaseSet(Set<String> input) {
        TreeSet<String> ret = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (input != null) {
            ret.addAll(input);
        }
        return ret;
    }

    private String[] toArray(Set<String> input) {
        return input.toArray(new String[input.size()]);
    }

    private boolean rowKeyColExistsInMultipleAggGroup() {
        if (this.oldAggGroup == null) {
            return false;
        }
        int total = 0;
        Set<String> overall = this.newIgnoreCaseSet(null);
        for (String[] group : this.oldAggGroup) {
            Set<String> temp = this.newIgnoreCaseSet(null);
            for (String entry : group) {
                overall.add(entry);
                temp.add(entry);
            }
            total += temp.size();
        }
        return overall.size() != total;
    }

    private void upgradeAggregationGroup(org.apache.kylin.cube.model.CubeDesc newModel) {
        ArrayList aggs = Lists.newArrayList();
        if (this.oldAggGroup == null || this.oldAggGroup.length == 0) {
            this.oldAggGroup = new String[1][];
            this.oldAggGroup[0] = this.toArray(this.allRowKeyCols);
        }
        if (this.rowKeyColExistsInMultipleAggGroup()) {
            throw new IllegalArgumentException("rowKeyColExistsInMultipleAggGroup!");
        }
        Set<String> visited = this.newIgnoreCaseSet(null);
        for (String[] group : this.oldAggGroup) {
            AggregationGroup agg = new AggregationGroup();
            Set<String> remaining = this.newIgnoreCaseSet(this.allRowKeyCols);
            remaining.removeAll(visited);
            Set<String> joint = this.newIgnoreCaseSet(remaining);
            joint.removeAll(this.oldMandatories);
            Set<String> groupAsSet = this.newIgnoreCaseSet(null);
            for (String entry : group) {
                groupAsSet.add(entry);
            }
            visited.addAll(groupAsSet);
            joint.removeAll(groupAsSet);
            ArrayList mandatories = Lists.newArrayList();
            ArrayList hierarchies = Lists.newArrayList();
            for (String s : this.oldMandatories) {
                mandatories.add(s);
            }
            for (String[] h : this.oldHierarchies) {
                if (!groupAsSet.containsAll(Arrays.asList(h))) continue;
                hierarchies.add(h);
            }
            agg.setIncludes(this.toArray(remaining));
            SelectRule selectRule = new SelectRule();
            selectRule.hierarchy_dims = (String[][])hierarchies.toArray((T[])new String[hierarchies.size()][]);
            if (joint.size() != 0) {
                selectRule.joint_dims = new String[1][];
                selectRule.joint_dims[0] = joint.toArray(new String[joint.size()]);
            } else {
                selectRule.joint_dims = new String[0][];
            }
            selectRule.mandatory_dims = mandatories.toArray(new String[mandatories.size()]);
            agg.setSelectRule(selectRule);
            aggs.add(agg);
        }
        newModel.setAggregationGroups(aggs);
    }

    private void upgradeDimension(CubeDesc oldModel, org.apache.kylin.cube.model.CubeDesc newModel) {
        List<DimensionDesc> oldDimensions = oldModel.getDimensions();
        if (oldDimensions == null) {
            throw new IllegalArgumentException("dimensions is null");
        }
        ArrayList newDimensions = Lists.newArrayList();
        for (DimensionDesc oldDim : oldDimensions) {
            if (oldDim.isDerived()) {
                org.apache.kylin.cube.model.DimensionDesc newDim = new org.apache.kylin.cube.model.DimensionDesc();
                newDim.setName(oldDim.getName());
                newDim.setTable(oldDim.getTable());
                newDim.setColumn("{FK}");
                newDim.setDerived(oldDim.getDerived());
                newDimensions.add(newDim);
                continue;
            }
            if (oldDim.isHierarchy()) {
                this.oldHierarchies.add(oldDim.getColumn());
            }
            for (String columnStr : oldDim.getColumn()) {
                org.apache.kylin.cube.model.DimensionDesc newDim = new org.apache.kylin.cube.model.DimensionDesc();
                newDim.setName(oldDim.getName());
                newDim.setTable(oldDim.getTable());
                newDim.setColumn(columnStr);
                newDim.setDerived(null);
                newDimensions.add(newDim);
            }
        }
        newModel.setDimensions(newDimensions);
    }

    private void upgradeRowKey(CubeDesc oldModel, org.apache.kylin.cube.model.CubeDesc newModel) {
        org.apache.kylin.cube.model.v1_4_0.RowKeyDesc oldRowKey = oldModel.getRowkey();
        if (oldModel == null) {
            throw new IllegalArgumentException("RowKeyDesc is null");
        }
        if (oldRowKey.getRowKeyColumns() == null) {
            throw new IllegalArgumentException("RowKeyDesc.getRowKeyColumns is null");
        }
        RowKeyDesc newRowKey = new RowKeyDesc();
        org.apache.kylin.cube.model.RowKeyColDesc[] cols = new org.apache.kylin.cube.model.RowKeyColDesc[oldRowKey.getRowKeyColumns().length];
        int index = 0;
        for (RowKeyColDesc oldRowKeyCol : oldRowKey.getRowKeyColumns()) {
            org.apache.kylin.cube.model.RowKeyColDesc newRowKeyCol = new org.apache.kylin.cube.model.RowKeyColDesc();
            this.allRowKeyCols.add(oldRowKeyCol.getColumn());
            if (oldRowKeyCol.isMandatory()) {
                this.oldMandatories.add(oldRowKeyCol.getColumn());
            }
            newRowKeyCol.setColumn(oldRowKeyCol.getColumn());
            if (oldRowKeyCol.getDictionary() != null && "true".equalsIgnoreCase(oldRowKeyCol.getDictionary())) {
                newRowKeyCol.setEncoding("dict");
            } else if (oldRowKeyCol.getLength() > 0) {
                newRowKeyCol.setEncoding("fixed_length:" + oldRowKeyCol.getLength());
            } else {
                throw new IllegalArgumentException("Unknow encoding: Dictionary " + oldRowKeyCol.getDictionary() + ", length: " + oldRowKeyCol.getLength());
            }
            cols[index++] = newRowKeyCol;
        }
        this.oldAggGroup = oldRowKey.getAggregationGroups();
        newRowKey.setRowkeyColumns(cols);
        newModel.setRowkey(newRowKey);
    }

    private void upgradeHBaseMapping(CubeDesc oldModel, org.apache.kylin.cube.model.CubeDesc newModel) {
        HBaseMappingDesc hbaseMappingDesc = oldModel.getHBaseMapping();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JsonUtil.writeValueIndent(os, hbaseMappingDesc);
            byte[] blob = os.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(blob);
            org.apache.kylin.cube.model.HBaseMappingDesc newHBaseMappingDesc = JsonUtil.readValue(is, org.apache.kylin.cube.model.HBaseMappingDesc.class);
            newModel.setHbaseMapping(newHBaseMappingDesc);
        }
        catch (IOException e) {
            throw new RuntimeException("error when copying HBaseMappingDesc");
        }
    }

    private void copyUnChangedProperties(CubeDesc oldModel, org.apache.kylin.cube.model.CubeDesc newModel) {
        newModel.setUuid(oldModel.getUuid());
        newModel.setName(oldModel.getName());
        newModel.setDescription(oldModel.getDescription());
        newModel.setMeasures(oldModel.getMeasures());
        newModel.setNullStrings(oldModel.getNullStrings());
        newModel.setModelName(oldModel.getModelName());
        newModel.setNotifyList(oldModel.getNotifyList());
        newModel.setLastModified(oldModel.getLastModified());
        newModel.setStorageType(oldModel.getStorageType());
        newModel.setEngineType(oldModel.getEngineType());
    }
}

