/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RowKeyColDesc {
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="encoding")
    private String encoding;
    @JsonProperty(value="isShardBy")
    private boolean isShardBy;
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String index;
    private String encodingName;
    private String[] encodingArgs;
    private int bitIndex;
    private TblColRef colRef;

    public void init() {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.encoding));
        String[] parts = this.encoding.split("\\s*[(),:]\\s*");
        if (parts == null || parts.length == 0 || parts[0].isEmpty()) {
            throw new IllegalArgumentException("Not supported row key col encoding: '" + this.encoding + "'");
        }
        this.encodingName = parts[0];
        String[] stringArray = this.encodingArgs = parts[parts.length - 1].isEmpty() ? StringUtil.subArray(parts, 1, parts.length - 1) : StringUtil.subArray(parts, 1, parts.length);
        if (!DimensionEncodingFactory.isVaildEncoding(this.encodingName)) {
            throw new IllegalArgumentException("Not supported row key col encoding: '" + this.encoding + "'");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isShardBy() {
        return this.isShardBy;
    }

    public void setShardBy(boolean shardBy) {
        this.isShardBy = shardBy;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public String[] getEncodingArgs() {
        return this.encodingArgs;
    }

    public boolean isUsingDictionary() {
        return "dict".equals(this.encodingName);
    }

    public int getBitIndex() {
        return this.bitIndex;
    }

    void setBitIndex(int index) {
        this.bitIndex = index;
    }

    public TblColRef getColRef() {
        return this.colRef;
    }

    void setColRef(TblColRef colRef) {
        this.colRef = colRef;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("column", (Object)this.column).add("encoding", (Object)this.encoding).toString();
    }
}

