/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.BytesSplitter;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.IntermediateColumnDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class CubeJoinedFlatTableDesc
implements IJoinedFlatTableDesc {
    private String tableName;
    private final CubeDesc cubeDesc;
    private final CubeSegment cubeSegment;
    private int columnCount;
    private int[] rowKeyColumnIndexes;
    private int[][] measureColumnIndexes;
    private List<IntermediateColumnDesc> columnList = Lists.newArrayList();
    private Map<String, Integer> columnIndexMap;

    public CubeJoinedFlatTableDesc(CubeDesc cubeDesc, CubeSegment cubeSegment) {
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.columnIndexMap = Maps.newHashMap();
        this.parseCubeDesc();
    }

    public CubeSegment getCubeSegment() {
        return this.cubeSegment;
    }

    private void parseCubeDesc() {
        int rowkeyColCount = this.cubeDesc.getRowkey().getRowKeyColumns().length;
        long baseCuboidId = Cuboid.getBaseCuboidId(this.cubeDesc);
        Cuboid baseCuboid = Cuboid.findById(this.cubeDesc, baseCuboidId);
        this.tableName = this.cubeSegment == null ? "kylin_intermediate_" + this.cubeDesc.getName() : "kylin_intermediate_" + this.cubeDesc.getName() + "_" + this.cubeSegment.getName();
        int columnIndex = 0;
        for (TblColRef col : this.cubeDesc.listDimensionColumnsExcludingDerived(false)) {
            this.columnIndexMap.put(CubeJoinedFlatTableDesc.colName(col.getCanonicalName()), columnIndex);
            this.columnList.add(new IntermediateColumnDesc(String.valueOf(columnIndex), col));
            ++columnIndex;
        }
        List<TblColRef> cuboidColumns = baseCuboid.getColumns();
        this.rowKeyColumnIndexes = new int[rowkeyColCount];
        for (int i = 0; i < rowkeyColCount; ++i) {
            String colName = CubeJoinedFlatTableDesc.colName(cuboidColumns.get(i).getCanonicalName());
            Integer dimIdx = this.columnIndexMap.get(colName);
            if (dimIdx == null) {
                throw new RuntimeException("Can't find column " + colName);
            }
            this.rowKeyColumnIndexes[i] = dimIdx;
        }
        List<MeasureDesc> measures = this.cubeDesc.getMeasures();
        int measureSize = measures.size();
        this.measureColumnIndexes = new int[measureSize][];
        for (int i = 0; i < measureSize; ++i) {
            FunctionDesc func = measures.get(i).getFunction();
            List<TblColRef> colRefs = func.getParameter().getColRefs();
            if (colRefs == null) {
                this.measureColumnIndexes[i] = null;
                continue;
            }
            this.measureColumnIndexes[i] = new int[colRefs.size()];
            for (int j = 0; j < colRefs.size(); ++j) {
                TblColRef c = colRefs.get(j);
                this.measureColumnIndexes[i][j] = this.contains(this.columnList, c);
                if (this.measureColumnIndexes[i][j] >= 0) continue;
                this.measureColumnIndexes[i][j] = columnIndex;
                this.columnIndexMap.put(CubeJoinedFlatTableDesc.colName(c.getCanonicalName()), columnIndex);
                this.columnList.add(new IntermediateColumnDesc(String.valueOf(columnIndex), c));
                ++columnIndex;
            }
        }
        this.columnCount = columnIndex;
    }

    private int contains(List<IntermediateColumnDesc> columnList, TblColRef c) {
        for (int i = 0; i < columnList.size(); ++i) {
            IntermediateColumnDesc col = columnList.get(i);
            if (!col.isSameAs(c.getTable(), c.getName())) continue;
            return i;
        }
        return -1;
    }

    public void sanityCheck(BytesSplitter bytesSplitter) {
        if (this.columnCount != bytesSplitter.getBufferSize()) {
            throw new IllegalArgumentException("Expect " + this.columnCount + " columns, but see " + bytesSplitter.getBufferSize() + " -- " + bytesSplitter);
        }
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public int[] getRowKeyColumnIndexes() {
        return this.rowKeyColumnIndexes;
    }

    public int[][] getMeasureColumnIndexes() {
        return this.measureColumnIndexes;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<IntermediateColumnDesc> getColumnList() {
        return this.columnList;
    }

    @Override
    public DataModelDesc getDataModel() {
        return this.cubeDesc.getModel();
    }

    @Override
    public DataModelDesc.RealizationCapacity getCapacity() {
        return this.cubeDesc.getModel().getCapacity();
    }

    private static String colName(String canonicalColName) {
        return canonicalColName.replace(".", "_");
    }

    public int getColumnIndex(TblColRef colRef) {
        String key = CubeJoinedFlatTableDesc.colName(colRef.getCanonicalName());
        Integer index = this.columnIndexMap.get(key);
        if (index == null) {
            throw new IllegalArgumentException("Column " + colRef.toString() + " wasn't found on flat table.");
        }
        return index;
    }
}

