/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.kv.RowConstants;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeyEncoder
extends AbstractRowKeyEncoder {
    private int bodyLength = 0;
    private RowKeyColumnIO colIO;
    protected boolean enableSharding;
    private int UHCOffset = -1;
    private int UHCLength = -1;

    public RowKeyEncoder(CubeSegment cubeSeg, Cuboid cuboid) {
        super(cubeSeg, cuboid);
        this.enableSharding = cubeSeg.isEnableSharding();
        Set<TblColRef> shardByColumns = cubeSeg.getShardByColumns();
        if (shardByColumns.size() > 1) {
            throw new IllegalStateException("Does not support multiple UHC now");
        }
        this.colIO = new RowKeyColumnIO(cubeSeg.getDimensionEncodingMap());
        for (TblColRef column : cuboid.getColumns()) {
            if (shardByColumns.contains(column)) {
                this.UHCOffset = this.bodyLength;
                this.UHCLength = this.colIO.getColumnLength(column);
            }
            this.bodyLength += this.colIO.getColumnLength(column);
        }
    }

    public int getHeaderLength() {
        return this.cubeSeg.getRowKeyPreambleSize();
    }

    public int getBytesLength() {
        return this.getHeaderLength() + this.bodyLength;
    }

    protected short calculateShard(byte[] key) {
        if (this.enableSharding) {
            int shardSeedOffset = this.UHCOffset == -1 ? 0 : this.UHCOffset;
            int shardSeedLength = this.UHCLength == -1 ? this.bodyLength : this.UHCLength;
            short cuboidShardNum = this.cubeSeg.getCuboidShardNum(this.cuboid.getId());
            short shardOffset = ShardingHash.getShard(key, 10 + shardSeedOffset, shardSeedLength, cuboidShardNum);
            return ShardingHash.normalize(this.cubeSeg.getCuboidBaseShard(this.cuboid.getId()), shardOffset, this.cubeSeg.getTotalShards());
        }
        throw new RuntimeException("If enableSharding false, you should never calculate shard");
    }

    public int getColumnLength(TblColRef col) {
        return this.colIO.getColumnLength(col);
    }

    @Override
    public byte[] createBuf() {
        return new byte[this.getBytesLength()];
    }

    @Override
    public void encode(GTRecord record, ImmutableBitSet keyColumns, byte[] buf) {
        ByteArray byteArray = new ByteArray(buf, this.getHeaderLength(), 0);
        record.exportColumns(keyColumns, byteArray, this.defaultValue());
        this.fillHeader(buf);
    }

    @Override
    public void encode(ByteArray bodyBytes, ByteArray outputBuf) {
        Preconditions.checkState((bodyBytes.length() == this.bodyLength ? 1 : 0) != 0);
        Preconditions.checkState((bodyBytes.length() + this.getHeaderLength() == outputBuf.length() ? 1 : 0) != 0, (Object)("bodybytes length: " + bodyBytes.length() + " outputBuf length: " + outputBuf.length() + " header length: " + this.getHeaderLength()));
        System.arraycopy(bodyBytes.array(), bodyBytes.offset(), outputBuf.array(), this.getHeaderLength(), this.bodyLength);
        this.fillHeader(outputBuf.array());
    }

    @Override
    public byte[] encode(Map<TblColRef, String> valueMap) {
        ArrayList<byte[]> valueList = new ArrayList<byte[]>();
        for (TblColRef bdCol : this.cuboid.getColumns()) {
            String value = valueMap.get(bdCol);
            valueList.add(this.valueStringToBytes(value));
        }
        byte[][] values = (byte[][])valueList.toArray((T[])RowConstants.BYTE_ARR_MARKER);
        return this.encode(values);
    }

    public byte[] valueStringToBytes(String value) {
        if (value == null) {
            return null;
        }
        return Bytes.toBytes(value);
    }

    @Override
    public byte[] encode(byte[][] values) {
        byte[] bytes = new byte[this.getBytesLength()];
        int offset = this.getHeaderLength();
        for (int i = 0; i < this.cuboid.getColumns().size(); ++i) {
            TblColRef column = this.cuboid.getColumns().get(i);
            int colLength = this.colIO.getColumnLength(column);
            byte[] value = values[i];
            if (value == null) {
                this.fillColumnValue(column, colLength, null, 0, bytes, offset);
            } else {
                this.fillColumnValue(column, colLength, value, value.length, bytes, offset);
            }
            offset += colLength;
        }
        this.fillHeader(bytes);
        return bytes;
    }

    protected void fillHeader(byte[] bytes) {
        int offset = 0;
        if (this.enableSharding) {
            short shard = this.calculateShard(bytes);
            BytesUtil.writeShort(shard, bytes, offset, 2);
            offset += 2;
        }
        System.arraycopy(this.cuboid.getBytes(), 0, bytes, offset, 8);
    }

    protected void fillColumnValue(TblColRef column, int columnLen, byte[] value, int valueLen, byte[] outputValue, int outputValueOffset) {
        if (value == null) {
            Arrays.fill(outputValue, outputValueOffset, outputValueOffset + columnLen, this.defaultValue());
            return;
        }
        this.colIO.writeColumn(column, value, valueLen, 0, this.blankByte, outputValue, outputValueOffset);
    }

    protected byte defaultValue() {
        return this.blankByte;
    }
}

