/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationSegment;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeSegment
implements Comparable<CubeSegment>,
IRealizationSegment {
    @JsonBackReference
    private CubeInstance cubeInstance;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="storage_location_identifier")
    private String storageLocationIdentifier;
    @JsonProperty(value="date_range_start")
    private long dateRangeStart;
    @JsonProperty(value="date_range_end")
    private long dateRangeEnd;
    @JsonProperty(value="status")
    private SegmentStatusEnum status;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records")
    private long inputRecords;
    @JsonProperty(value="input_records_size")
    private long inputRecordsSize;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="last_build_job_id")
    private String lastBuildJobID;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="cuboid_shard_nums")
    private Map<Long, Short> cuboidShardNums = Maps.newHashMap();
    @JsonProperty(value="total_shards")
    private int totalShards = 0;
    @JsonProperty(value="blackout_cuboids")
    private List<Long> blackoutCuboids = Lists.newArrayList();
    @JsonProperty(value="binary_signature")
    private String binarySignature;
    @JsonProperty(value="dictionaries")
    private ConcurrentHashMap<String, String> dictionaries;
    @JsonProperty(value="snapshots")
    private ConcurrentHashMap<String, String> snapshots;
    @JsonProperty(value="index_path")
    private String indexPath;
    @JsonProperty(value="rowkey_stats")
    private List<Object[]> rowkeyStats = Lists.newArrayList();
    private volatile Map<Long, Short> cuboidBaseShards = Maps.newHashMap();

    public CubeDesc getCubeDesc() {
        return this.getCubeInstance().getDescriptor();
    }

    public static String getSegmentName(long startDate, long endDate) {
        if (startDate == 0L && endDate == 0L) {
            return "FULL_BUILD";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(startDate) + "_" + dateFormat.format(endDate);
    }

    @Override
    public KylinConfig getConfig() {
        return this.cubeInstance.getConfig();
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String id) {
        this.uuid = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDateRangeStart() {
        return this.dateRangeStart;
    }

    public void setDateRangeStart(long dateRangeStart) {
        this.dateRangeStart = dateRangeStart;
    }

    public long getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    public void setDateRangeEnd(long dateRangeEnd) {
        this.dateRangeEnd = dateRangeEnd;
    }

    public SegmentStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(SegmentStatusEnum status) {
        this.status = status;
    }

    public long getSizeKB() {
        return this.sizeKB;
    }

    public void setSizeKB(long sizeKB) {
        this.sizeKB = sizeKB;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    public void setInputRecords(long inputRecords) {
        this.inputRecords = inputRecords;
    }

    public long getInputRecordsSize() {
        return this.inputRecordsSize;
    }

    public void setInputRecordsSize(long inputRecordsSize) {
        this.inputRecordsSize = inputRecordsSize;
    }

    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    public String getLastBuildJobID() {
        return this.lastBuildJobID;
    }

    public void setLastBuildJobID(String lastBuildJobID) {
        this.lastBuildJobID = lastBuildJobID;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    public String getBinarySignature() {
        return this.binarySignature;
    }

    public void setBinarySignature(String binarySignature) {
        this.binarySignature = binarySignature;
    }

    public CubeInstance getCubeInstance() {
        return this.cubeInstance;
    }

    public void setCubeInstance(CubeInstance cubeInstance) {
        this.cubeInstance = cubeInstance;
    }

    @Override
    public String getStorageLocationIdentifier() {
        return this.storageLocationIdentifier;
    }

    public List<Object[]> getRowkeyStats() {
        return this.rowkeyStats;
    }

    public Map<String, String> getDictionaries() {
        if (this.dictionaries == null) {
            this.dictionaries = new ConcurrentHashMap();
        }
        return this.dictionaries;
    }

    public Map<String, String> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new ConcurrentHashMap();
        }
        return this.snapshots;
    }

    public String getSnapshotResPath(String table) {
        return this.getSnapshots().get(table);
    }

    public void putSnapshotResPath(String table, String snapshotResPath) {
        this.getSnapshots().put(table, snapshotResPath);
    }

    public Collection<String> getDictionaryPaths() {
        return this.getDictionaries().values();
    }

    public Collection<String> getSnapshotPaths() {
        return this.getSnapshots().values();
    }

    public String getDictResPath(TblColRef col) {
        return this.getDictionaries().get(this.dictKey(col));
    }

    public void putDictResPath(TblColRef col, String dictResPath) {
        this.getDictionaries().put(this.dictKey(col), dictResPath);
    }

    private String dictKey(TblColRef col) {
        return col.getTable() + "/" + col.getName();
    }

    public void setStorageLocationIdentifier(String storageLocationIdentifier) {
        this.storageLocationIdentifier = storageLocationIdentifier;
    }

    public Map<TblColRef, Dictionary<String>> buildDictionaryMap() {
        HashMap result = Maps.newHashMap();
        for (TblColRef col : this.getCubeDesc().getAllColumnsNeedDictionary()) {
            result.put(col, this.getDictionary(col));
        }
        return result;
    }

    public Dictionary<String> getDictionary(TblColRef col) {
        return CubeManager.getInstance(this.getCubeInstance().getConfig()).getDictionary(this, col);
    }

    public CubeDimEncMap getDimensionEncodingMap() {
        return new CubeDimEncMap(this);
    }

    public void validate() {
        if (this.cubeInstance.getDescriptor().getModel().getPartitionDesc().isPartitioned() && this.dateRangeStart >= this.dateRangeEnd) {
            throw new IllegalStateException("dateRangeStart(" + this.dateRangeStart + ") must be smaller than dateRangeEnd(" + this.dateRangeEnd + ") in segment " + this);
        }
    }

    @Override
    public int compareTo(CubeSegment other) {
        long comp = this.dateRangeStart - other.dateRangeStart;
        if (comp != 0L) {
            return comp < 0L ? -1 : 1;
        }
        comp = this.dateRangeEnd - other.dateRangeEnd;
        if (comp != 0L) {
            return comp < 0L ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cubeInstance == null ? 0 : this.cubeInstance.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CubeSegment other = (CubeSegment)obj;
        if (this.cubeInstance == null ? other.cubeInstance != null : !this.cubeInstance.equals(other.cubeInstance)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return this.cubeInstance.getName() + "[" + this.name + "]";
    }

    public void setDictionaries(ConcurrentHashMap<String, String> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public void setSnapshots(ConcurrentHashMap<String, String> snapshots) {
        this.snapshots = snapshots;
    }

    public String getStatisticsResourcePath() {
        return CubeSegment.getStatisticsResourcePath(this.getCubeInstance().getName(), this.getUuid());
    }

    public static String getStatisticsResourcePath(String cubeName, String cubeSegmentId) {
        return "/cube_statistics/" + cubeName + "/" + cubeSegmentId + ".seq";
    }

    @Override
    public int getSourceType() {
        return this.cubeInstance.getSourceType();
    }

    @Override
    public int getEngineType() {
        return this.cubeInstance.getEngineType();
    }

    @Override
    public int getStorageType() {
        return this.cubeInstance.getStorageType();
    }

    public boolean isEnableSharding() {
        return this.getCubeDesc().isEnableSharding();
    }

    public Set<TblColRef> getShardByColumns() {
        return this.getCubeDesc().getShardByColumns();
    }

    public int getRowKeyPreambleSize() {
        return this.isEnableSharding() ? 10 : 8;
    }

    public Short getCuboidShardNum(Long cuboidId) {
        Short ret = this.cuboidShardNums.get(cuboidId);
        if (ret == null) {
            return (short)1;
        }
        return ret;
    }

    public void setCuboidShardNums(Map<Long, Short> newCuboidShards) {
        this.cuboidShardNums = newCuboidShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public void setTotalShards(int totalShards) {
        this.totalShards = totalShards;
    }

    public short getCuboidBaseShard(Long cuboidId) {
        Short ret = this.cuboidBaseShards.get(cuboidId);
        if (ret == null) {
            ret = ShardingHash.getShard(cuboidId, this.totalShards);
            this.cuboidBaseShards.put(cuboidId, ret);
        }
        return ret;
    }

    public List<Long> getBlackoutCuboids() {
        return this.blackoutCuboids;
    }

    @Override
    public IRealization getRealization() {
        return this.cubeInstance;
    }

    @Override
    public IJoinedFlatTableDesc getJoinedFlatTableDesc() {
        return new CubeJoinedFlatTableDesc(this.getCubeDesc(), this);
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }
}

