/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeCapabilityChecker {
    private static final Logger logger = LoggerFactory.getLogger(CubeCapabilityChecker.class);

    public static CapabilityResult check(CubeInstance cube, SQLDigest digest) {
        CapabilityResult result = new CapabilityResult();
        result.capable = false;
        boolean isJoinMatch = CubeCapabilityChecker.isJoinMatch(digest.joinDescs, cube);
        if (!isJoinMatch) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched joins");
            return result;
        }
        Collection<TblColRef> dimensionColumns = CubeCapabilityChecker.getDimensionColumns(digest);
        Collection<FunctionDesc> aggrFunctions = digest.aggregations;
        Set<TblColRef> unmatchedDimensions = CubeCapabilityChecker.unmatchedDimensions(dimensionColumns, cube);
        Set<FunctionDesc> unmatchedAggregations = CubeCapabilityChecker.unmatchedAggregations(aggrFunctions, cube);
        CubeCapabilityChecker.tryCustomMeasureTypes(unmatchedDimensions, unmatchedAggregations, digest, cube, result);
        if (!unmatchedAggregations.isEmpty()) {
            CubeCapabilityChecker.tryDimensionAsMeasures(unmatchedAggregations, digest, cube, result);
        }
        if (!unmatchedDimensions.isEmpty()) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched dimensions");
            return result;
        }
        if (!unmatchedAggregations.isEmpty()) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched aggregations");
            return result;
        }
        if (cube.getStorageType() == 0 && MassInTupleFilter.containsMassInTupleFilter(digest.filter)) {
            logger.info("Exclude cube " + cube.getName() + " because only v2 storage + v2 query engine supports massin");
            return result;
        }
        result.capable = true;
        return result;
    }

    private static Collection<TblColRef> getDimensionColumns(SQLDigest sqlDigest) {
        Collection<TblColRef> groupByColumns = sqlDigest.groupbyColumns;
        Collection<TblColRef> filterColumns = sqlDigest.filterColumns;
        HashSet<TblColRef> dimensionColumns = new HashSet<TblColRef>();
        dimensionColumns.addAll(groupByColumns);
        dimensionColumns.addAll(filterColumns);
        return dimensionColumns;
    }

    private static Set<TblColRef> unmatchedDimensions(Collection<TblColRef> dimensionColumns, CubeInstance cube) {
        HashSet result = Sets.newHashSet(dimensionColumns);
        CubeDesc cubeDesc = cube.getDescriptor();
        result.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
        return result;
    }

    private static Set<FunctionDesc> unmatchedAggregations(Collection<FunctionDesc> aggregations, CubeInstance cube) {
        HashSet result = Sets.newHashSet(aggregations);
        CubeDesc cubeDesc = cube.getDescriptor();
        result.removeAll(cubeDesc.listAllFunctions());
        return result;
    }

    private static boolean isJoinMatch(Collection<JoinDesc> joins, CubeInstance cube) {
        CubeDesc cubeDesc = cube.getDescriptor();
        ArrayList<JoinDesc> cubeJoins = new ArrayList<JoinDesc>(cubeDesc.getDimensions().size());
        for (DimensionDesc d : cubeDesc.getDimensions()) {
            if (d.getJoin() == null) continue;
            cubeJoins.add(d.getJoin());
        }
        for (JoinDesc j : joins) {
            String fTable;
            String pTable = j.getPrimaryKeyColumns()[0].getTable();
            String factTable = cubeDesc.getFactTable();
            if (factTable.equals(pTable)) {
                j.swapPKFK();
            }
            if (!factTable.equals(fTable = j.getForeignKeyColumns()[0].getTable())) {
                logger.info("Fact Table" + factTable + " not matched in join: " + j + " on cube " + cube.getName());
                return false;
            }
            if (cubeJoins.contains(j)) continue;
            logger.info("Query joins don't macth on cube " + cube.getName());
            return false;
        }
        return true;
    }

    private static void tryDimensionAsMeasures(Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, CubeInstance cube, CapabilityResult result) {
        CubeDesc cubeDesc = cube.getDescriptor();
        List<FunctionDesc> cubeFuncs = cubeDesc.listAllFunctions();
        Iterator<FunctionDesc> it = unmatchedAggregations.iterator();
        while (it.hasNext()) {
            FunctionDesc functionDesc = it.next();
            if (cubeFuncs.contains(functionDesc)) {
                it.remove();
                continue;
            }
            if (functionDesc.isCount()) {
                it.remove();
                continue;
            }
            List<TblColRef> neededCols = functionDesc.getParameter().getColRefs();
            if (neededCols.size() <= 0 || !cubeDesc.listDimensionColumnsIncludingDerived().containsAll(neededCols) || !FunctionDesc.BUILT_IN_AGGREGATIONS.contains(functionDesc.getExpression())) continue;
            result.influences.add(new CapabilityResult.DimensionAsMeasure(functionDesc));
            it.remove();
        }
    }

    private static void tryCustomMeasureTypes(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, CubeInstance cube, CapabilityResult result) {
        CubeDesc cubeDesc = cube.getDescriptor();
        for (MeasureDesc measure : cubeDesc.getMeasures()) {
            CapabilityResult.CapabilityInfluence inf;
            MeasureType<?> measureType = measure.getFunction().getMeasureType();
            if (measureType instanceof BasicMeasureType || (inf = measureType.influenceCapabilityCheck(unmatchedDimensions, unmatchedAggregations, digest, measure)) == null) continue;
            result.influences.add(inf);
        }
    }
}

