/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ZipFileUtils {
    public static void compressZipFile(String sourceDir, String zipFilename) throws IOException {
        if (!ZipFileUtils.validateZipFilename(zipFilename)) {
            throw new RuntimeException("Zipfile must end with .zip");
        }
        ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(zipFilename));
        ZipFileUtils.compressDirectoryToZipfile(ZipFileUtils.normDir(new File(sourceDir).getParent()), ZipFileUtils.normDir(sourceDir), zipFile);
        IOUtils.closeQuietly((OutputStream)zipFile);
    }

    private static void compressDirectoryToZipfile(String rootDir, String sourceDir, ZipOutputStream out) throws IOException {
        for (File sourceFile : new File(sourceDir).listFiles()) {
            if (sourceFile.isDirectory()) {
                ZipFileUtils.compressDirectoryToZipfile(rootDir, sourceDir + ZipFileUtils.normDir(sourceFile.getName()), out);
                continue;
            }
            ZipEntry entry = new ZipEntry(ZipFileUtils.normDir(StringUtils.isEmpty((String)rootDir) ? sourceDir : sourceDir.replace(rootDir, "")) + sourceFile.getName());
            entry.setTime(sourceFile.lastModified());
            out.putNextEntry(entry);
            FileInputStream in = new FileInputStream(sourceDir + sourceFile.getName());
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static boolean validateZipFilename(String filename) {
        return !StringUtils.isEmpty((String)filename) && filename.trim().toLowerCase().endsWith(".zip");
    }

    private static String normDir(String dirName) {
        if (!StringUtils.isEmpty((String)dirName) && !dirName.endsWith(File.separator)) {
            dirName = dirName + File.separator;
        }
        return dirName;
    }
}

