/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;

public class NumberIterators {
    public static <T extends Number> long sum(Iterator<T> iterator) {
        long ret = 0L;
        while (iterator.hasNext()) {
            Number element = (Number)iterator.next();
            ret += element.longValue();
        }
        return ret;
    }

    public static <T extends Number> long checkSame(Iterator<T> iterator) {
        HashSet values = Sets.newHashSet();
        while (iterator.hasNext()) {
            Number element = (Number)iterator.next();
            values.add(element.longValue());
        }
        if (values.size() > 1) {
            throw new IllegalStateException("more than one distinct values exist in the collection:" + values);
        }
        return (Long)values.iterator().next();
    }
}

