/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log4jConfigurer {
    private static boolean INITIALIZED = false;

    public static void initLogger() {
        if (!INITIALIZED && !Log4jConfigurer.isConfigured()) {
            InputStream is = Log4jConfigurer.class.getClassLoader().getResourceAsStream("kylin-log4j.properties");
            PropertyConfigurator.configure((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
        }
        INITIALIZED = true;
    }

    private static boolean isConfigured() {
        if (LogManager.getRootLogger().getAllAppenders().hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }
}

