/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class DateFormat {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String[] SUPPORTED_DATETIME_PATTERN = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyyMMdd"};
    private static final Map<String, ThreadLocal<SimpleDateFormat>> threadLocalMap = new ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>>();

    public static SimpleDateFormat getDateFormat(String datePattern) {
        SimpleDateFormat format;
        ThreadLocal<SimpleDateFormat> formatThreadLocal = threadLocalMap.get(datePattern);
        if (formatThreadLocal == null) {
            formatThreadLocal = new ThreadLocal();
            threadLocalMap.put(datePattern, formatThreadLocal);
        }
        if ((format = formatThreadLocal.get()) == null) {
            format = new SimpleDateFormat(datePattern);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            formatThreadLocal.set(format);
        }
        return format;
    }

    public static String formatToDateStr(long millis) {
        return DateFormat.formatToDateStr(millis, DEFAULT_DATE_PATTERN);
    }

    public static String formatToDateStr(long millis, String pattern) {
        return DateFormat.getDateFormat(pattern).format(new Date(millis));
    }

    public static String formatToTimeStr(long millis) {
        return DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS);
    }

    public static String formatToTimeWithoutMilliStr(long millis) {
        return DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS);
    }

    public static String formatToTimeStr(long millis, String pattern) {
        return DateFormat.getDateFormat(pattern).format(new Date(millis));
    }

    public static String dateToString(Date date, String pattern) {
        return DateFormat.getDateFormat(pattern).format(date);
    }

    public static Date stringToDate(String str) {
        return DateFormat.stringToDate(str, DEFAULT_DATE_PATTERN);
    }

    public static Date stringToDate(String str, String pattern) {
        Date date = null;
        try {
            date = DateFormat.getDateFormat(pattern).parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("'" + str + "' is not a valid date of pattern '" + pattern + "'", e);
        }
        return date;
    }

    public static long stringToMillis(String str) {
        return DateFormat.stringToMillis(str, DEFAULT_DATE_PATTERN);
    }

    public static long stringToMillis(String str, String partitionDateFormat) {
        if (DateFormat.isAllDigits(str)) {
            return Long.parseLong(str);
        }
        if (str.length() == 8 && partitionDateFormat.length() == 8) {
            return DateFormat.stringToDate(str, partitionDateFormat).getTime();
        }
        if (str.length() == 10 && partitionDateFormat.length() == 10) {
            return DateFormat.stringToDate(str, DEFAULT_DATE_PATTERN).getTime();
        }
        if (str.length() == 19) {
            return DateFormat.stringToDate(str, DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS).getTime();
        }
        if (str.length() > 19) {
            return DateFormat.stringToDate(str, DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS).getTime();
        }
        throw new IllegalArgumentException("there is no valid date pattern for:" + str);
    }

    private static boolean isAllDigits(String str) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSupportedDateFormat(String dateStr) {
        assert (dateStr != null);
        for (String formatStr : SUPPORTED_DATETIME_PATTERN) {
            try {
                if (!dateStr.equals(DateFormat.dateToString(DateFormat.stringToDate(dateStr, formatStr), formatStr))) continue;
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }
}

