/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.restclient;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.restclient.AbstractRestCache;
import org.apache.kylin.common.restclient.Broadcaster;

public abstract class SingleValueCache<K, V>
extends AbstractRestCache<K, V> {
    private final ConcurrentMap<K, V> innerCache;

    public SingleValueCache(KylinConfig config, Broadcaster.TYPE syncType) {
        this(config, syncType, new ConcurrentHashMap());
    }

    public SingleValueCache(KylinConfig config, Broadcaster.TYPE syncType, ConcurrentMap<K, V> innerCache) {
        super(config, syncType);
        this.innerCache = innerCache;
    }

    @Override
    public void put(K key, V value) {
        boolean exists = this.innerCache.containsKey(key);
        this.innerCache.put(key, value);
        if (!exists) {
            this.getBroadcaster().queue(this.syncType.getType(), Broadcaster.EVENT.CREATE.getType(), key.toString());
        } else {
            this.getBroadcaster().queue(this.syncType.getType(), Broadcaster.EVENT.UPDATE.getType(), key.toString());
        }
    }

    @Override
    public void putLocal(K key, V value) {
        this.innerCache.put(key, value);
    }

    @Override
    public void remove(K key) {
        boolean exists = this.innerCache.containsKey(key);
        this.innerCache.remove(key);
        if (exists) {
            this.getBroadcaster().queue(this.syncType.getType(), Broadcaster.EVENT.DROP.getType(), key.toString());
        }
    }

    @Override
    public void removeLocal(K key) {
        this.innerCache.remove(key);
    }

    @Override
    public void clear() {
        this.innerCache.clear();
    }

    @Override
    public int size() {
        return this.innerCache.size();
    }

    public V get(K key) {
        return this.innerCache.get(key);
    }

    public Collection<V> values() {
        return this.innerCache.values();
    }

    public boolean containsKey(String key) {
        return this.innerCache.containsKey(key);
    }

    public Map<K, V> getMap() {
        return Collections.unmodifiableMap(this.innerCache);
    }

    public Set<K> keySet() {
        return this.innerCache.keySet();
    }
}

