/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.StringUtil;

public class ResourceTool {
    private static String[] includes = null;
    private static String[] excludes = null;

    public static void main(String[] args) throws IOException {
        String cmd;
        String exclude;
        if ((args = StringUtil.filterSystemArgs(args)).length == 0) {
            System.out.println("Usage: ResourceTool list  RESOURCE_PATH");
            System.out.println("Usage: ResourceTool download  LOCAL_DIR");
            System.out.println("Usage: ResourceTool upload    LOCAL_DIR");
            System.out.println("Usage: ResourceTool reset");
            System.out.println("Usage: ResourceTool remove RESOURCE_PATH");
            System.out.println("Usage: ResourceTool cat RESOURCE_PATH");
            return;
        }
        String include = System.getProperty("include");
        if (include != null) {
            includes = include.split("\\s*,\\s*");
        }
        if ((exclude = System.getProperty("exclude")) != null) {
            excludes = exclude.split("\\s*,\\s*");
        }
        switch (cmd = args[0]) {
            case "reset": {
                ResourceTool.reset(args.length == 1 ? KylinConfig.getInstanceFromEnv() : KylinConfig.createInstanceFromUri(args[1]));
                break;
            }
            case "list": {
                ResourceTool.list(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            case "download": {
                ResourceTool.copy(KylinConfig.getInstanceFromEnv(), KylinConfig.createInstanceFromUri(args[1]));
                break;
            }
            case "upload": {
                ResourceTool.copy(KylinConfig.createInstanceFromUri(args[1]), KylinConfig.getInstanceFromEnv());
                break;
            }
            case "remove": {
                ResourceTool.remove(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            case "cat": {
                ResourceTool.cat(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            default: {
                System.out.println("Unknown cmd: " + cmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        InputStream is = store.getResource((String)path).inputStream;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)br);
    }

    public static void list(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        NavigableSet<String> result = store.listResources(path);
        System.out.println("" + result);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths) throws IOException {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        for (String path : paths) {
            ResourceTool.copyR(src, dst, path);
        }
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        ResourceTool.copyR(src, dst, "/");
    }

    public static void copyR(ResourceStore src, ResourceStore dst, String path) throws IOException {
        block7: {
            NavigableSet<String> children = src.listResources(path);
            if (children == null) {
                if (ResourceTool.matchFilter(path)) {
                    try {
                        RawResource res = src.getResource(path);
                        if (res != null) {
                            dst.putResource(path, res.inputStream, res.timestamp);
                            res.inputStream.close();
                            break block7;
                        }
                        System.out.println("Resource not exist for " + path);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to open " + path);
                        ex.printStackTrace();
                    }
                }
            } else {
                for (String child : children) {
                    ResourceTool.copyR(src, dst, child);
                }
            }
        }
    }

    private static boolean matchFilter(String path) {
        if (includes != null) {
            boolean in = false;
            for (String include : includes) {
                in = in || path.startsWith(include);
            }
            if (!in) {
                return false;
            }
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!path.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    public static void reset(KylinConfig config) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        ResourceTool.resetR(store, "/");
    }

    public static void resetR(ResourceStore store, String path) throws IOException {
        NavigableSet<String> children = store.listResources(path);
        if (children == null) {
            if (ResourceTool.matchFilter(path)) {
                store.deleteResource(path);
            }
        } else {
            for (String child : children) {
                ResourceTool.resetR(store, child);
            }
        }
    }

    private static void remove(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        ResourceTool.resetR(store, path);
    }
}

