/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.FileResourceStore;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStore.class);
    public static final String CUBE_RESOURCE_ROOT = "/cube";
    public static final String II_RESOURCE_ROOT = "/invertedindex";
    public static final String CUBE_DESC_RESOURCE_ROOT = "/cube_desc";
    public static final String II_DESC_RESOURCE_ROOT = "/invertedindex_desc";
    public static final String DATA_MODEL_DESC_RESOURCE_ROOT = "/model_desc";
    public static final String DICT_RESOURCE_ROOT = "/dict";
    public static final String PROJECT_RESOURCE_ROOT = "/project";
    public static final String SNAPSHOT_RESOURCE_ROOT = "/table_snapshot";
    public static final String TABLE_EXD_RESOURCE_ROOT = "/table_exd";
    public static final String TABLE_RESOURCE_ROOT = "/table";
    public static final String EXTERNAL_FILTER_RESOURCE_ROOT = "/ext_filter";
    public static final String HYBRID_RESOURCE_ROOT = "/hybrid";
    public static final String EXECUTE_RESOURCE_ROOT = "/execute";
    public static final String EXECUTE_OUTPUT_RESOURCE_ROOT = "/execute_output";
    public static final String STREAMING_RESOURCE_ROOT = "/streaming";
    public static final String KAFKA_RESOURCE_ROOT = "/kafka";
    public static final String STREAMING_OUTPUT_RESOURCE_ROOT = "/streaming_output";
    public static final String CUBE_STATISTICS_ROOT = "/cube_statistics";
    public static final String BAD_QUERY_RESOURCE_ROOT = "/bad_query";
    private static final ConcurrentHashMap<KylinConfig, ResourceStore> CACHE = new ConcurrentHashMap();
    private static final ArrayList<Class<? extends ResourceStore>> knownImpl = new ArrayList();
    protected final KylinConfig kylinConfig;

    private static ArrayList<Class<? extends ResourceStore>> getKnownImpl() {
        if (knownImpl.isEmpty()) {
            knownImpl.add(FileResourceStore.class);
            try {
                knownImpl.add(ClassUtil.forName("org.apache.kylin.storage.hbase.HBaseResourceStore", ResourceStore.class));
            }
            catch (Throwable e) {
                logger.warn("Failed to load ResourceStore impl class: " + e.toString());
            }
        }
        return knownImpl;
    }

    private static ResourceStore createResourceStore(KylinConfig kylinConfig) {
        ArrayList<Throwable> es = new ArrayList<Throwable>();
        logger.info("Using metadata url " + kylinConfig.getMetadataUrl() + " for resource store");
        for (Class<? extends ResourceStore> cls : ResourceStore.getKnownImpl()) {
            try {
                return cls.getConstructor(KylinConfig.class).newInstance(kylinConfig);
            }
            catch (Throwable e) {
                es.add(e);
            }
        }
        for (Throwable exceptionOrError : es) {
            logger.error("Create new store instance failed ", exceptionOrError);
        }
        throw new IllegalArgumentException("Failed to find metadata store by url: " + kylinConfig.getMetadataUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceStore getStore(KylinConfig kylinConfig) {
        if (CACHE.containsKey(kylinConfig)) {
            return CACHE.get(kylinConfig);
        }
        Class<ResourceStore> clazz = ResourceStore.class;
        synchronized (ResourceStore.class) {
            if (CACHE.containsKey(kylinConfig)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return CACHE.get(kylinConfig);
            }
            CACHE.putIfAbsent(kylinConfig, ResourceStore.createResourceStore(kylinConfig));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return CACHE.get(kylinConfig);
        }
    }

    public ResourceStore(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public final NavigableSet<String> listResources(String folderPath) throws IOException {
        String path = this.norm(folderPath);
        return this.listResourcesImpl(path);
    }

    protected abstract NavigableSet<String> listResourcesImpl(String var1) throws IOException;

    public final boolean exists(String resPath) throws IOException {
        return this.existsImpl(this.norm(resPath));
    }

    protected abstract boolean existsImpl(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends RootPersistentEntity> T getResource(String resPath, Class<T> clz, Serializer<T> serializer) throws IOException {
        RawResource res = this.getResourceImpl(resPath = this.norm(resPath));
        if (res == null) {
            return null;
        }
        DataInputStream din = new DataInputStream(res.inputStream);
        try {
            T r = serializer.deserialize(din);
            ((RootPersistentEntity)r).setLastModified(res.timestamp);
            T t = r;
            return t;
        }
        finally {
            IOUtils.closeQuietly((InputStream)din);
            IOUtils.closeQuietly((InputStream)res.inputStream);
        }
    }

    public final RawResource getResource(String resPath) throws IOException {
        return this.getResourceImpl(this.norm(resPath));
    }

    public final long getResourceTimestamp(String resPath) throws IOException {
        return this.getResourceTimestampImpl(this.norm(resPath));
    }

    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, Class<T> clazz, Serializer<T> serializer) throws IOException {
        return this.getAllResources(folderPath, Long.MIN_VALUE, Long.MAX_VALUE, clazz, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, long timeStart, long timeEndExclusive, Class<T> clazz, Serializer<T> serializer) throws IOException {
        ArrayList arrayList;
        List<RawResource> allResources = this.getAllResourcesImpl(folderPath, timeStart, timeEndExclusive);
        if (allResources == null || allResources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)allResources.size());
        try {
            for (RawResource rawResource : allResources) {
                T element = serializer.deserialize(new DataInputStream(rawResource.inputStream));
                ((RootPersistentEntity)element).setLastModified(rawResource.timestamp);
                result.add(element);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            for (RawResource rawResource : allResources) {
                if (rawResource == null) continue;
                IOUtils.closeQuietly((InputStream)rawResource.inputStream);
            }
            throw throwable;
        }
        for (RawResource rawResource : allResources) {
            if (rawResource == null) continue;
            IOUtils.closeQuietly((InputStream)rawResource.inputStream);
        }
        return arrayList;
    }

    protected abstract List<RawResource> getAllResourcesImpl(String var1, long var2, long var4) throws IOException;

    protected abstract RawResource getResourceImpl(String var1) throws IOException;

    protected abstract long getResourceTimestampImpl(String var1) throws IOException;

    public final void putResource(String resPath, InputStream content, long ts) throws IOException {
        resPath = this.norm(resPath);
        logger.debug("Directly saving resource " + resPath + " (Store " + this.kylinConfig.getMetadataUrl() + ")");
        this.putResourceImpl(resPath, content, ts);
    }

    protected abstract void putResourceImpl(String var1, InputStream var2, long var3) throws IOException;

    public final <T extends RootPersistentEntity> long putResource(String resPath, T obj, Serializer<T> serializer) throws IOException {
        return this.putResource(resPath, obj, System.currentTimeMillis(), serializer);
    }

    public final <T extends RootPersistentEntity> long putResource(String resPath, T obj, long newTS, Serializer<T> serializer) throws IOException {
        resPath = this.norm(resPath);
        long oldTS = obj.getLastModified();
        obj.setLastModified(newTS);
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(buf);
            serializer.serialize(obj, dout);
            dout.close();
            buf.close();
            newTS = this.checkAndPutResourceImpl(resPath, buf.toByteArray(), oldTS, newTS);
            obj.setLastModified(newTS);
            return newTS;
        }
        catch (IOException e) {
            obj.setLastModified(oldTS);
            throw e;
        }
        catch (RuntimeException e) {
            obj.setLastModified(oldTS);
            throw e;
        }
    }

    protected abstract long checkAndPutResourceImpl(String var1, byte[] var2, long var3, long var5) throws IOException, IllegalStateException;

    public final void deleteResource(String resPath) throws IOException {
        logger.debug("Deleting resource " + resPath + " (Store " + this.kylinConfig.getMetadataUrl() + ")");
        this.deleteResourceImpl(this.norm(resPath));
    }

    protected abstract void deleteResourceImpl(String var1) throws IOException;

    public final String getReadableResourcePath(String resPath) {
        return this.getReadableResourcePathImpl(this.norm(resPath));
    }

    protected abstract String getReadableResourcePathImpl(String var1);

    private String norm(String resPath) {
        resPath = resPath.trim();
        while (resPath.startsWith("//")) {
            resPath = resPath.substring(1);
        }
        while (resPath.endsWith("/")) {
            resPath = resPath.substring(0, resPath.length() - 1);
        }
        if (!resPath.startsWith("/")) {
            resPath = "/" + resPath;
        }
        return resPath;
    }

    public void scanRecursively(String path, Visitor visitor) throws IOException {
        NavigableSet<String> children = this.listResources(path);
        if (children != null) {
            for (String child : children) {
                this.scanRecursively(child, visitor);
            }
            return;
        }
        if (this.exists(path)) {
            visitor.visit(path);
        }
    }

    public List<String> collectResourceRecursively(String root, final String suffix) throws IOException {
        final ArrayList collector = Lists.newArrayList();
        this.scanRecursively(root, new Visitor(){

            @Override
            public void visit(String path) {
                if (path.endsWith(suffix)) {
                    collector.add(path);
                }
            }
        });
        return collector;
    }

    public static interface Visitor {
        public void visit(String var1) throws IOException;
    }
}

