/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.debug;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.Pair;

public class BackdoorToggles {
    private static final ThreadLocal<Map<String, String>> _backdoorToggles = new ThreadLocal();
    public static final String DEBUG_TOGGLE_DISABLE_FUZZY_KEY = "DEBUG_TOGGLE_DISABLE_FUZZY_KEY";
    public static final String DEBUG_TOGGLE_DISABLE_QUERY_CACHE = "DEBUG_TOGGLE_DISABLE_QUERY_CACHE";
    public static final String DEBUG_TOGGLE_HBASE_CUBE_QUERY_VERSION = "DEBUG_TOGGLE_HBASE_CUBE_QUERY_VERSION";
    public static final String DEBUG_TOGGLE_HBASE_CUBE_QUERY_PROTOCOL = "DEBUG_TOGGLE_HBASE_CUBE_QUERY_PROTOCOL";
    public static final String DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR = "DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR";
    public static final String DEBUG_TOGGLE_LOCAL_COPROCESSOR = "DEBUG_TOGGLE_LOCAL_COPROCESSOR";
    public static final String DEBUG_TOGGLE_QUERY_TIMEOUT = "DEBUG_TOGGLE_QUERY_TIMEOUT";
    public static final String DEBUG_TOGGLE_SHARD_ASSIGNMENT = "DEBUG_TOGGLE_SHARD_ASSIGNMENT";

    public static void setToggles(Map<String, String> toggles) {
        _backdoorToggles.set(toggles);
    }

    public static String getCoprocessorBehavior() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR);
    }

    public static String getHbaseCubeQueryVersion() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_HBASE_CUBE_QUERY_VERSION);
    }

    public static String getHbaseCubeQueryProtocol() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_HBASE_CUBE_QUERY_PROTOCOL);
    }

    public static boolean getDisableCache() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_QUERY_CACHE);
    }

    public static boolean getDisableFuzzyKey() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_FUZZY_KEY);
    }

    public static boolean getRunLocalCoprocessor() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_LOCAL_COPROCESSOR);
    }

    public static int getQueryTimeout() {
        String v = BackdoorToggles.getString(DEBUG_TOGGLE_QUERY_TIMEOUT);
        if (v == null) {
            return -1;
        }
        return Integer.valueOf(v);
    }

    public static Pair<Short, Short> getShardAssignment() {
        String v = BackdoorToggles.getString(DEBUG_TOGGLE_SHARD_ASSIGNMENT);
        if (v == null) {
            return null;
        }
        String[] parts = StringUtils.split((String)v, (String)"#");
        return Pair.newPair(Short.valueOf(parts[0]), Short.valueOf(parts[1]));
    }

    private static String getString(String key) {
        Map<String, String> toggles = _backdoorToggles.get();
        if (toggles == null) {
            return null;
        }
        return toggles.get(key);
    }

    private static boolean getBoolean(String key) {
        return "true".equals(BackdoorToggles.getString(key));
    }

    public static void cleanToggles() {
        _backdoorToggles.remove();
    }
}

