/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.HadoopUtil;

public class ToolUtil {
    public static String getConfFolder() {
        String CONF = "conf";
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty((String)path)) {
            return path;
        }
        path = KylinConfig.getKylinHome();
        if (StringUtils.isNotEmpty((String)path)) {
            return path + File.separator + "conf";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHBaseMetaStoreId() throws IOException {
        try (HBaseAdmin hbaseAdmin = new HBaseAdmin(HBaseConfiguration.create((Configuration)HadoopUtil.getCurrentConfiguration()));){
            String metaStoreName = KylinConfig.getInstanceFromEnv().getMetadataUrlPrefix();
            HTableDescriptor desc = hbaseAdmin.getTableDescriptor(TableName.valueOf((String)metaStoreName));
            String string = desc.getValue("UUID");
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decideKylinMajorVersionFromCommitFile() {
        HashMap majorVersionCommitMap = Maps.newHashMap();
        majorVersionCommitMap.put("1.3", "commit.sha1");
        majorVersionCommitMap.put("1.5", "commit_SHA1");
        for (Map.Entry majorVersionEntry : majorVersionCommitMap.entrySet()) {
            if (!new File(KylinConfig.getKylinHome(), (String)majorVersionEntry.getValue()).exists()) continue;
            return (String)majorVersionEntry.getKey();
        }
        return null;
    }
}

