/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;

public class ResourceStoreUtil {
    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths) throws Exception {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        for (String path : paths) {
            ResourceStoreUtil.rCopy(src, dst, path);
        }
    }

    public static void rCopy(ResourceStore src, ResourceStore dst, String path) throws Exception {
        block6: {
            Method listResourceMethod = ResourceStore.class.getMethod("listResources", String.class);
            Iterable children = (Iterable)listResourceMethod.invoke((Object)src, path);
            if (children == null) {
                try {
                    RawResource res = src.getResource(path);
                    if (res != null) {
                        dst.putResource(path, res.inputStream, res.timestamp);
                        res.inputStream.close();
                        break block6;
                    }
                    System.out.println("Resource not exist for " + path);
                }
                catch (Exception ex) {
                    System.err.println("Failed to open " + path);
                    ex.printStackTrace();
                }
            } else {
                for (String child : children) {
                    ResourceStoreUtil.rCopy(src, dst, child);
                }
            }
        }
    }

    public static String concatCubeDescResourcePath(String descName) {
        return "/cube_desc/" + descName + ".json";
    }

    public static String concatCubeSegmentStatisticsResourcePath(String cubeName, String cubeSegmentId) {
        return "/cube_statistics/" + cubeName + "/" + cubeSegmentId + ".seq";
    }

    public static String concatJobPath(String uuid) {
        return "/execute/" + uuid;
    }

    public static String concatJobOutputPath(String uuid) {
        return "/execute_output/" + uuid;
    }
}

