/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.ClientEnvExtractor;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.apache.kylin.tool.HBaseUsageExtractor;
import org.apache.kylin.tool.KylinLogExtractor;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosisInfoCLI
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisInfoCLI.class);
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_INCLUDE_CONF;
    private static final Option OPTION_INCLUDE_HBASE;
    private static final Option OPTION_INCLUDE_CLIENT;

    public DiagnosisInfoCLI() {
        this.packageType = "project";
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_INCLUDE_CONF);
        this.options.addOption(OPTION_INCLUDE_HBASE);
        this.options.addOption(OPTION_INCLUDE_CLIENT);
    }

    public static void main(String[] args) {
        DiagnosisInfoCLI diagnosisInfoCLI = new DiagnosisInfoCLI();
        diagnosisInfoCLI.execute(args);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws IOException {
        String project = optionsHelper.getOptionValue(this.options.getOption("project"));
        boolean includeConf = optionsHelper.hasOption(OPTION_INCLUDE_CONF) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_CONF)) : true;
        boolean includeHBase = optionsHelper.hasOption(OPTION_INCLUDE_HBASE) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_HBASE)) : true;
        boolean includeClient = optionsHelper.hasOption(OPTION_INCLUDE_CLIENT) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_CLIENT)) : true;
        Object[] cubeMetaArgs = new String[]{"-destDir", new File(exportDir, "metadata").getAbsolutePath(), "-project", project, "-compress", "false", "-submodule", "true"};
        CubeMetaExtractor cubeMetaExtractor = new CubeMetaExtractor();
        logger.info("CubeMetaExtractor args: " + Arrays.toString(cubeMetaArgs));
        cubeMetaExtractor.execute((String[])cubeMetaArgs);
        if (includeHBase) {
            Object[] hbaseArgs = new String[]{"-destDir", new File(exportDir, "hbase").getAbsolutePath(), "-project", project, "-compress", "false", "-submodule", "true"};
            HBaseUsageExtractor hBaseUsageExtractor = new HBaseUsageExtractor();
            logger.info("HBaseUsageExtractor args: " + Arrays.toString(hbaseArgs));
            hBaseUsageExtractor.execute((String[])hbaseArgs);
        }
        if (includeConf) {
            logger.info("Start to extract kylin conf files.");
            try {
                FileUtils.copyDirectoryToDirectory((File)new File(ToolUtil.getConfFolder()), (File)exportDir);
            }
            catch (Exception e) {
                logger.warn("Error in export conf.", (Throwable)e);
            }
        }
        if (includeClient) {
            Object[] clientArgs = new String[]{"-destDir", new File(exportDir, "client").getAbsolutePath(), "-compress", "false", "-submodule", "true"};
            ClientEnvExtractor clientEnvExtractor = new ClientEnvExtractor();
            logger.info("ClientEnvExtractor args: " + Arrays.toString(clientArgs));
            clientEnvExtractor.execute((String[])clientArgs);
        }
        Object[] logsArgs = new String[]{"-destDir", new File(exportDir, "logs").getAbsolutePath(), "-compress", "false", "-submodule", "true"};
        KylinLogExtractor logExtractor = new KylinLogExtractor();
        logger.info("KylinLogExtractor args: " + Arrays.toString(logsArgs));
        logExtractor.execute((String[])logsArgs);
    }

    static {
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"includeConf");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include conf files to extract. Default true.");
        OPTION_INCLUDE_CONF = OptionBuilder.create((String)"includeConf");
        OptionBuilder.withArgName((String)"includeHBase");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include hbase files to extract. Default true.");
        OPTION_INCLUDE_HBASE = OptionBuilder.create((String)"includeHBase");
        OptionBuilder.withArgName((String)"includeClient");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include client info to extract. Default true.");
        OPTION_INCLUDE_CLIENT = OptionBuilder.create((String)"includeClient");
    }
}

