/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.util.ResourceStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetaExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaExtractor.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_HYBRID;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_INCLUDE_SEGMENTS;
    private static final Option OPTION_INCLUDE_JOB;
    private static final Option OPTION_INCLUDE_SEGMENT_DETAILS;
    private KylinConfig kylinConfig;
    private MetadataManager metadataManager;
    private ProjectManager projectManager;
    private HybridManager hybridManager;
    private CubeManager cubeManager;
    private CubeDescManager cubeDescManager;
    private ExecutableDao executableDao;
    private RealizationRegistry realizationRegistry;
    private BadQueryHistoryManager badQueryHistoryManager;
    boolean includeSegments;
    boolean includeJobs;
    boolean includeSegmentDetails;
    List<String> requiredResources = Lists.newArrayList();
    List<String> optionalResources = Lists.newArrayList();
    List<CubeInstance> cubesToTrimAndSave = Lists.newArrayList();

    public CubeMetaExtractor() {
        this.packageType = "cubemeta";
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.addOption(OPTION_HYBRID);
        realizationOrProject.setRequired(true);
        this.options.addOptionGroup(realizationOrProject);
        this.options.addOption(OPTION_INCLUDE_SEGMENTS);
        this.options.addOption(OPTION_INCLUDE_JOB);
        this.options.addOption(OPTION_INCLUDE_SEGMENT_DETAILS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.includeSegments = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENTS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENTS)) : true;
        this.includeJobs = optionsHelper.hasOption(OPTION_INCLUDE_JOB) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_JOB)) : false;
        this.includeSegmentDetails = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENT_DETAILS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENT_DETAILS)) : false;
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.metadataManager = MetadataManager.getInstance(this.kylinConfig);
        this.projectManager = ProjectManager.getInstance(this.kylinConfig);
        this.hybridManager = HybridManager.getInstance(this.kylinConfig);
        this.cubeManager = CubeManager.getInstance(this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance(this.kylinConfig);
        this.executableDao = ExecutableDao.getInstance(this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance(this.kylinConfig);
        this.badQueryHistoryManager = BadQueryHistoryManager.getInstance(this.kylinConfig);
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String projectName = optionsHelper.getOptionValue(OPTION_PROJECT);
            ProjectInstance projectInstance = this.projectManager.getProject(projectName);
            if (projectInstance == null) {
                throw new IllegalArgumentException("Project " + projectName + " does not exist");
            }
            this.addRequired(projectInstance.getResourcePath());
            List<RealizationEntry> realizationEntries = projectInstance.getRealizationEntries();
            for (RealizationEntry realizationEntry : realizationEntries) {
                this.retrieveResourcePath(this.getRealization(realizationEntry));
            }
            this.addOptional(this.badQueryHistoryManager.getBadQueriesForProject(projectName).getResourcePath());
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeName = optionsHelper.getOptionValue(OPTION_CUBE);
            IRealization realization = this.cubeManager.getRealization(cubeName);
            if (realization == null) throw new IllegalArgumentException("No cube found with name of " + cubeName);
            this.retrieveResourcePath(realization);
        } else if (optionsHelper.hasOption(OPTION_HYBRID)) {
            String hybridName = optionsHelper.getOptionValue(OPTION_HYBRID);
            IRealization realization = this.hybridManager.getRealization(hybridName);
            if (realization == null) throw new IllegalArgumentException("No hybrid found with name of" + hybridName);
            this.retrieveResourcePath(realization);
        }
        this.executeExtraction(exportDir.getAbsolutePath());
    }

    private void executeExtraction(String dest) {
        logger.info("The resource paths going to be extracted:");
        for (String s : this.requiredResources) {
            logger.info(s + "(required)");
        }
        for (String s : this.optionalResources) {
            logger.info(s + "(optional)");
        }
        for (CubeInstance cube : this.cubesToTrimAndSave) {
            logger.info("Cube {} will be trimmed and extracted", (Object)cube);
        }
        try {
            KylinConfig srcConfig = KylinConfig.getInstanceFromEnv();
            KylinConfig dstConfig = KylinConfig.createInstanceFromUri(dest);
            ResourceStoreUtil.copy(srcConfig, dstConfig, this.requiredResources);
            try {
                ResourceStoreUtil.copy(srcConfig, dstConfig, this.optionalResources);
            }
            catch (Exception e) {
                logger.warn("Exception when copying optional resource {}. May be caused by resource missing. Ignore it.");
            }
            ResourceStore dstStore = ResourceStore.getStore(dstConfig);
            for (CubeInstance cube : this.cubesToTrimAndSave) {
                CubeInstance trimmedCube = CubeMetaExtractor.copyCubeInstance(cube);
                trimmedCube.getSegments().clear();
                trimmedCube.setUuid(cube.getUuid());
                dstStore.putResource(trimmedCube.getResourcePath(), trimmedCube, CubeManager.CUBE_SERIALIZER);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception", e);
        }
    }

    private IRealization getRealization(RealizationEntry realizationEntry) {
        return this.realizationRegistry.getRealization(realizationEntry.getType(), realizationEntry.getRealization());
    }

    private static CubeInstance copyCubeInstance(CubeInstance cubeInstance) {
        CubeInstance newCube = new CubeInstance();
        newCube.setName(cubeInstance.getName());
        newCube.setSegments(cubeInstance.getSegments());
        newCube.setDescName(cubeInstance.getDescName());
        newCube.setStatus(cubeInstance.getStatus());
        newCube.setOwner(cubeInstance.getOwner());
        newCube.setCost(cubeInstance.getCost());
        newCube.setCreateTimeUTC(System.currentTimeMillis());
        newCube.updateRandomUuid();
        return newCube;
    }

    private void retrieveResourcePath(IRealization realization) {
        logger.info("Deal with realization {} of type {}", (Object)realization.getName(), (Object)realization.getType());
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            String descName = cube.getDescName();
            CubeDesc cubeDesc = this.cubeDescManager.getCubeDesc(descName);
            String modelName = cubeDesc.getModelName();
            DataModelDesc modelDesc = this.metadataManager.getDataModelDesc(modelName);
            for (String tableName : modelDesc.getAllTables()) {
                this.addRequired(TableDesc.concatResourcePath(tableName));
                this.addOptional(TableDesc.concatExdResourcePath(tableName));
            }
            this.addRequired(DataModelDesc.concatResourcePath(modelDesc.getName()));
            this.addRequired(ResourceStoreUtil.concatCubeDescResourcePath(cubeDesc.getName()));
            if (this.includeSegments) {
                this.addRequired(CubeInstance.concatResourcePath(cube.getName()));
                for (CubeSegment segment : cube.getSegments(SegmentStatusEnum.READY)) {
                    this.addRequired(ResourceStoreUtil.concatCubeSegmentStatisticsResourcePath(cube.getName(), segment.getUuid()));
                    if (this.includeSegmentDetails) {
                        for (String dictPat : segment.getDictionaryPaths()) {
                            this.addRequired(dictPat);
                        }
                        for (String snapshotPath : segment.getSnapshotPaths()) {
                            this.addRequired(snapshotPath);
                        }
                    }
                    if (!this.includeJobs) continue;
                    String lastJobId = segment.getLastBuildJobID();
                    if (StringUtils.isEmpty((CharSequence)lastJobId)) {
                        throw new RuntimeException("No job exist for segment :" + segment);
                    }
                    try {
                        ExecutablePO executablePO = this.executableDao.getJob(lastJobId);
                        this.addRequired(ResourceStoreUtil.concatJobPath(lastJobId));
                        this.addRequired(ResourceStoreUtil.concatJobOutputPath(lastJobId));
                        for (ExecutablePO task : executablePO.getTasks()) {
                            this.addRequired(ResourceStoreUtil.concatJobPath(task.getUuid()));
                            this.addRequired(ResourceStoreUtil.concatJobOutputPath(task.getUuid()));
                        }
                    }
                    catch (PersistentException e) {
                        throw new RuntimeException("PersistentException", e);
                    }
                }
            } else {
                if (this.includeJobs) {
                    logger.warn("It's useless to set includeJobs to true when includeSegments is set to false");
                }
                this.cubesToTrimAndSave.add(cube);
            }
        } else if (realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)realization;
            this.addRequired(HybridInstance.concatResourcePath(hybridInstance.getName()));
            for (IRealization iRealization : hybridInstance.getRealizations()) {
                if (iRealization.getType() != RealizationType.CUBE) {
                    throw new RuntimeException("Hybrid " + iRealization.getName() + " contains non cube child " + iRealization.getName() + " with type " + (Object)((Object)iRealization.getType()));
                }
                this.retrieveResourcePath(iRealization);
            }
        } else {
            logger.warn("Unknown realization type: " + (Object)((Object)realization.getType()));
        }
    }

    private void addRequired(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.requiredResources.add(record);
    }

    private void addOptional(String record) {
        logger.info("adding optional resource {}", (Object)record);
        this.optionalResources.add(record);
    }

    public static void main(String[] args) {
        CubeMetaExtractor extractor = new CubeMetaExtractor();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"hybrid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which hybrid to extract");
        OPTION_HYBRID = OptionBuilder.create((String)"hybrid");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"includeSegments");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want extract the segments info. Default true");
        OPTION_INCLUDE_SEGMENTS = OptionBuilder.create((String)"includeSegments");
        OptionBuilder.withArgName((String)"includeJobs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract job info/outputs too. Default false");
        OPTION_INCLUDE_JOB = OptionBuilder.create((String)"includeJobs");
        OptionBuilder.withArgName((String)"includeSegmentDetails");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract segment details too, such as dict, tablesnapshot. Default false");
        OPTION_INCLUDE_SEGMENT_DETAILS = OptionBuilder.create((String)"includeSegmentDetails");
    }
}

