/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.translate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.kv.FuzzyKeyEncoder;
import org.apache.kylin.cube.kv.FuzzyMaskEncoder;
import org.apache.kylin.cube.kv.LazyRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.translate.ColumnValueRange;
import org.apache.kylin.storage.translate.FuzzyValueCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseKeyRange
implements Comparable<HBaseKeyRange> {
    private static final Logger logger = LoggerFactory.getLogger(HBaseKeyRange.class);
    private static final int FUZZY_VALUE_CAP = 100;
    private static final byte[] ZERO_TAIL_BYTES = new byte[]{0};
    private final CubeSegment cubeSeg;
    private final Cuboid cuboid;
    private final List<Collection<ColumnValueRange>> flatOrAndFilter;
    private byte[] startKey;
    private byte[] stopKey;
    private List<Pair<byte[], byte[]>> fuzzyKeys;
    private String startKeyString;
    private String stopKeyString;
    private String fuzzyKeyString;
    private long partitionColumnStartDate = Long.MIN_VALUE;
    private long partitionColumnEndDate = Long.MAX_VALUE;

    public HBaseKeyRange(CubeSegment cubeSeg, Cuboid cuboid, byte[] startKey, byte[] stopKey, List<Pair<byte[], byte[]>> fuzzyKeys, List<Collection<ColumnValueRange>> flatColumnValueFilter, long partitionColumnStartDate, long partitionColumnEndDate) {
        this.cubeSeg = cubeSeg;
        this.cuboid = cuboid;
        this.startKey = startKey;
        this.stopKey = stopKey;
        this.fuzzyKeys = fuzzyKeys;
        this.flatOrAndFilter = flatColumnValueFilter;
        this.partitionColumnStartDate = partitionColumnStartDate;
        this.partitionColumnEndDate = partitionColumnEndDate;
        this.initDebugString();
    }

    public HBaseKeyRange(Collection<TblColRef> dimensionColumns, Collection<ColumnValueRange> andDimensionRanges, CubeSegment cubeSeg, CubeDesc cubeDesc) {
        this.cubeSeg = cubeSeg;
        long cuboidId = this.calculateCuboidID(cubeDesc, dimensionColumns);
        this.cuboid = Cuboid.findById(cubeDesc, cuboidId);
        this.flatOrAndFilter = Lists.newLinkedList();
        this.flatOrAndFilter.add(andDimensionRanges);
        this.init(andDimensionRanges);
        this.initDebugString();
    }

    private long calculateCuboidID(CubeDesc cube, Collection<TblColRef> dimensions) {
        long cuboidID = 0L;
        for (TblColRef column : dimensions) {
            int index = cube.getRowkey().getColumnBitIndex(column);
            cuboidID |= 1L << index;
        }
        return cuboidID;
    }

    private void init(Collection<ColumnValueRange> andDimensionRanges) {
        int size = andDimensionRanges.size();
        HashMap startValues = Maps.newHashMapWithExpectedSize((int)size);
        HashMap stopValues = Maps.newHashMapWithExpectedSize((int)size);
        HashMap fuzzyValues = Maps.newHashMapWithExpectedSize((int)size);
        for (ColumnValueRange dimRange : andDimensionRanges) {
            TblColRef column = dimRange.getColumn();
            startValues.put(column, dimRange.getBeginValue());
            stopValues.put(column, dimRange.getEndValue());
            fuzzyValues.put(column, dimRange.getEqualValues());
            TblColRef partitionDateColumnRef = this.cubeSeg.getCubeDesc().getModel().getPartitionDesc().getPartitionDateColumnRef();
            if (!column.equals(partitionDateColumnRef)) continue;
            this.initPartitionRange(dimRange, this.cubeSeg.getCubeDesc().getModel().getPartitionDesc().getPartitionDateFormat());
        }
        LazyRowKeyEncoder encoder = new LazyRowKeyEncoder(this.cubeSeg, this.cuboid);
        encoder.setBlankByte((byte)0);
        this.startKey = ((AbstractRowKeyEncoder)encoder).encode(startValues);
        encoder.setBlankByte((byte)-1);
        this.stopKey = Bytes.add(((AbstractRowKeyEncoder)encoder).encode(stopValues), ZERO_TAIL_BYTES);
        this.fuzzyKeys = this.buildFuzzyKeys(fuzzyValues);
    }

    private void initPartitionRange(ColumnValueRange dimRange, String partitionDateFormat) {
        if (null != dimRange.getBeginValue()) {
            this.partitionColumnStartDate = DateFormat.stringToMillis(dimRange.getBeginValue(), partitionDateFormat);
        }
        if (null != dimRange.getEndValue()) {
            this.partitionColumnEndDate = DateFormat.stringToMillis(dimRange.getEndValue(), partitionDateFormat);
        }
    }

    private void initDebugString() {
        this.startKeyString = BytesUtil.toHex(this.startKey);
        this.stopKeyString = BytesUtil.toHex(this.stopKey);
        StringBuilder buf = new StringBuilder();
        for (Pair<byte[], byte[]> fuzzyKey : this.fuzzyKeys) {
            buf.append(BytesUtil.toHex(fuzzyKey.getFirst()));
            buf.append(" ");
            buf.append(BytesUtil.toHex(fuzzyKey.getSecond()));
            buf.append(";");
        }
        this.fuzzyKeyString = buf.toString();
    }

    private List<Pair<byte[], byte[]>> buildFuzzyKeys(Map<TblColRef, Set<String>> fuzzyValueSet) {
        ArrayList<Pair<byte[], byte[]>> result = new ArrayList<Pair<byte[], byte[]>>();
        if (BackdoorToggles.getDisableFuzzyKey()) {
            logger.info("The execution of this query will not use fuzzy key");
            return result;
        }
        FuzzyKeyEncoder fuzzyKeyEncoder = new FuzzyKeyEncoder(this.cubeSeg, this.cuboid);
        FuzzyMaskEncoder fuzzyMaskEncoder = new FuzzyMaskEncoder(this.cubeSeg, this.cuboid);
        List fuzzyValues = FuzzyValueCombination.calculate(fuzzyValueSet, 100L);
        for (Map<TblColRef, String> map : fuzzyValues) {
            result.add(Pair.newPair(fuzzyKeyEncoder.encode(map), fuzzyMaskEncoder.encode(map)));
        }
        return result;
    }

    public CubeSegment getCubeSegment() {
        return this.cubeSeg;
    }

    public Cuboid getCuboid() {
        return this.cuboid;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getStopKey() {
        return this.stopKey;
    }

    public List<Pair<byte[], byte[]>> getFuzzyKeys() {
        return this.fuzzyKeys;
    }

    public String getStartKeyAsString() {
        return this.startKeyString;
    }

    public String getStopKeyAsString() {
        return this.stopKeyString;
    }

    public String getFuzzyKeyAsString() {
        return this.fuzzyKeyString;
    }

    public List<Collection<ColumnValueRange>> getFlatOrAndFilter() {
        return this.flatOrAndFilter;
    }

    public long getPartitionColumnStartDate() {
        return this.partitionColumnStartDate;
    }

    public long getPartitionColumnEndDate() {
        return this.partitionColumnEndDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cubeSeg == null ? 0 : this.cubeSeg.hashCode());
        result = 31 * result + (this.cuboid == null ? 0 : this.cuboid.hashCode());
        result = 31 * result + (this.fuzzyKeyString == null ? 0 : this.fuzzyKeyString.hashCode());
        result = 31 * result + (this.startKeyString == null ? 0 : this.startKeyString.hashCode());
        result = 31 * result + (this.stopKeyString == null ? 0 : this.stopKeyString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HBaseKeyRange other = (HBaseKeyRange)obj;
        if (this.cubeSeg == null ? other.cubeSeg != null : !this.cubeSeg.equals(other.cubeSeg)) {
            return false;
        }
        if (this.cuboid == null ? other.cuboid != null : !this.cuboid.equals(other.cuboid)) {
            return false;
        }
        if (this.fuzzyKeyString == null ? other.fuzzyKeyString != null : !this.fuzzyKeyString.equals(other.fuzzyKeyString)) {
            return false;
        }
        if (this.startKeyString == null ? other.startKeyString != null : !this.startKeyString.equals(other.startKeyString)) {
            return false;
        }
        return !(this.stopKeyString == null ? other.stopKeyString != null : !this.stopKeyString.equals(other.stopKeyString));
    }

    @Override
    public int compareTo(HBaseKeyRange other) {
        return Bytes.compareTo(this.startKey, other.startKey);
    }

    public boolean hitSegment() {
        return this.cubeSeg.getDateRangeStart() <= this.getPartitionColumnEndDate() && this.cubeSeg.getDateRangeEnd() >= this.getPartitionColumnStartDate();
    }
}

