/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.translate;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.kylin.cube.kv.RowKeyColumnOrder;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;

public class ColumnValueRange {
    private TblColRef column;
    private RowKeyColumnOrder order;
    private String beginValue;
    private String endValue;
    private Set<String> equalValues;

    public ColumnValueRange(TblColRef column, Collection<String> values, TupleFilter.FilterOperatorEnum op) {
        this.column = column;
        this.order = RowKeyColumnOrder.getInstance(column.getType());
        switch (op) {
            case EQ: 
            case IN: {
                this.equalValues = new HashSet<String>(values);
                this.refreshBeginEndFromEquals();
                break;
            }
            case LT: 
            case LTE: {
                this.endValue = this.order.max(values);
                break;
            }
            case GT: 
            case GTE: {
                this.beginValue = this.order.min(values);
                break;
            }
            case NEQ: 
            case NOTIN: 
            case ISNULL: 
            case ISNOTNULL: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(op.name());
            }
        }
    }

    public ColumnValueRange(TblColRef column, String beginValue, String endValue, Set<String> equalValues) {
        this.copy(column, beginValue, endValue, equalValues);
    }

    void copy(TblColRef column, String beginValue, String endValue, Set<String> equalValues) {
        this.column = column;
        this.order = RowKeyColumnOrder.getInstance(column.getType());
        this.beginValue = beginValue;
        this.endValue = endValue;
        this.equalValues = equalValues;
    }

    public TblColRef getColumn() {
        return this.column;
    }

    public String getBeginValue() {
        return this.beginValue;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public Set<String> getEqualValues() {
        return this.equalValues;
    }

    private void refreshBeginEndFromEquals() {
        this.beginValue = this.order.min(this.equalValues);
        this.endValue = this.order.max(this.equalValues);
    }

    public boolean satisfyAll() {
        return this.beginValue == null && this.endValue == null && this.equalValues == null;
    }

    public boolean satisfyNone() {
        if (this.equalValues != null) {
            return this.equalValues.isEmpty();
        }
        if (this.beginValue != null && this.endValue != null) {
            return this.order.compare(this.beginValue, this.endValue) > 0;
        }
        return false;
    }

    public void andMerge(ColumnValueRange another) {
        assert (this.column.equals(another.column));
        if (another.satisfyAll()) {
            return;
        }
        if (this.satisfyAll()) {
            this.copy(another.column, another.beginValue, another.endValue, another.equalValues);
            return;
        }
        if (this.equalValues != null && another.equalValues != null) {
            this.equalValues.retainAll(another.equalValues);
            this.refreshBeginEndFromEquals();
            return;
        }
        if (this.equalValues != null) {
            this.equalValues = this.filter(this.equalValues, another.beginValue, another.endValue);
            this.refreshBeginEndFromEquals();
            return;
        }
        if (another.equalValues != null) {
            this.equalValues = this.filter(another.equalValues, this.beginValue, this.endValue);
            this.refreshBeginEndFromEquals();
            return;
        }
        this.beginValue = this.order.max(this.beginValue, another.beginValue);
        this.endValue = this.order.min(this.endValue, another.endValue);
    }

    private Set<String> filter(Set<String> equalValues, String beginValue, String endValue) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)equalValues.size());
        for (String v : equalValues) {
            if (!this.between(v, beginValue, endValue)) continue;
            result.add(v);
        }
        return equalValues;
    }

    private boolean between(String v, String beginValue, String endValue) {
        return !(beginValue != null && this.order.compare(beginValue, v) > 0 || endValue != null && this.order.compare(v, endValue) > 0);
    }

    public void preEvaluateWithDict(Dictionary<String> dict) {
        if (dict == null) {
            return;
        }
        if (this.equalValues != null) {
            Iterator<String> it = this.equalValues.iterator();
            while (it.hasNext()) {
                String v = it.next();
                try {
                    dict.getIdFromValue(v);
                }
                catch (IllegalArgumentException e) {
                    it.remove();
                }
            }
            this.refreshBeginEndFromEquals();
        }
        if (this.beginValue != null) {
            try {
                this.beginValue = dict.getValueFromId(dict.getIdFromValue(this.beginValue, 1));
            }
            catch (IllegalArgumentException e) {
                this.equalValues = Sets.newHashSet();
            }
        }
        if (this.endValue != null) {
            try {
                this.endValue = dict.getValueFromId(dict.getIdFromValue(this.endValue, -1));
            }
            catch (IllegalArgumentException e) {
                this.equalValues = Sets.newHashSet();
            }
        }
    }

    public String toString() {
        if (this.equalValues == null) {
            return this.column.getName() + " between " + this.beginValue + " and " + this.endValue;
        }
        return this.column.getName() + " in " + this.equalValues;
    }
}

