/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hybrid;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridManager
implements IRealizationProvider {
    public static final Serializer<HybridInstance> HYBRID_SERIALIZER = new JsonSerializer<HybridInstance>(HybridInstance.class);
    private static final Logger logger = LoggerFactory.getLogger(HybridManager.class);
    private static final ConcurrentHashMap<KylinConfig, HybridManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private CaseInsensitiveStringCache<HybridInstance> hybridMap;

    public static HybridManager getInstance(KylinConfig config) {
        HybridManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<HybridManager> clazz = HybridManager.class;
        synchronized (HybridManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new HybridManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one Hybrid Manager singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init Hybrid Manager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private HybridManager(KylinConfig config) throws IOException {
        logger.info("Initializing HybridManager with config " + config);
        this.config = config;
        this.hybridMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.HYBRID);
        this.loadAllHybridInstance();
    }

    private void loadAllHybridInstance() throws IOException {
        ResourceStore store = this.getStore();
        List<String> paths = store.collectResourceRecursively("/hybrid", ".json");
        logger.debug("Loading Hybrid from folder " + store.getReadableResourcePath("/hybrid"));
        for (String path : paths) {
            this.loadHybridInstance(path);
        }
        logger.debug("Loaded " + paths.size() + " Hybrid(s)");
    }

    public void reloadHybridInstanceByChild(RealizationType type, String realizationName) {
        for (HybridInstance hybridInstance : this.hybridMap.values()) {
            boolean includes = false;
            for (IRealization realization : hybridInstance.getRealizations()) {
                if (realization.getType() != type || !realization.getName().equalsIgnoreCase(realizationName)) continue;
                includes = true;
                break;
            }
            if (!includes) continue;
            this.loadHybridInstance(HybridInstance.concatResourcePath(hybridInstance.getName()));
        }
    }

    private synchronized HybridInstance loadHybridInstance(String path) {
        ResourceStore store = this.getStore();
        HybridInstance hybridInstance = null;
        try {
            hybridInstance = store.getResource(path, HybridInstance.class, HYBRID_SERIALIZER);
            hybridInstance.setConfig(this.config);
            if (hybridInstance.getRealizationEntries() == null || hybridInstance.getRealizationEntries().size() == 0) {
                throw new IllegalStateException("HybridInstance must have realization entries, " + path);
            }
            if (StringUtils.isBlank((CharSequence)hybridInstance.getName())) {
                throw new IllegalStateException("HybridInstance name must not be blank, at " + path);
            }
            String name = hybridInstance.getName();
            this.hybridMap.putLocal(name, hybridInstance);
            return hybridInstance;
        }
        catch (Exception e) {
            logger.error("Error during load hybrid instance " + path, (Throwable)e);
            return null;
        }
    }

    @Override
    public RealizationType getRealizationType() {
        return RealizationType.HYBRID;
    }

    @Override
    public IRealization getRealization(String name) {
        return this.getHybridInstance(name);
    }

    public HybridInstance getHybridInstance(String name) {
        return (HybridInstance)this.hybridMap.get(name);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }
}

