/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hybrid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HybridInstance
extends RootPersistentEntity
implements IRealization {
    @JsonIgnore
    private KylinConfig config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="realizations")
    private List<RealizationEntry> realizationEntries;
    @JsonProperty(value="cost")
    private int cost = 50;
    private volatile IRealization[] realizations = null;
    private List<TblColRef> allDimensions = null;
    private List<TblColRef> allColumns = null;
    private List<MeasureDesc> allMeasures = null;
    private long dateRangeStart;
    private long dateRangeEnd;
    private boolean isReady = false;
    private static final Logger logger = LoggerFactory.getLogger(HybridInstance.class);

    public void setRealizationEntries(List<RealizationEntry> realizationEntries) {
        this.realizationEntries = realizationEntries;
    }

    public List<RealizationEntry> getRealizationEntries() {
        return this.realizationEntries;
    }

    public static HybridInstance create(KylinConfig config, String name, List<RealizationEntry> realizationEntries) {
        HybridInstance hybridInstance = new HybridInstance();
        hybridInstance.setConfig(config);
        hybridInstance.setName(name);
        hybridInstance.setRealizationEntries(realizationEntries);
        hybridInstance.updateRandomUuid();
        return hybridInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.realizations != null) {
            return;
        }
        HybridInstance hybridInstance = this;
        synchronized (hybridInstance) {
            if (this.realizations != null) {
                return;
            }
            if (this.realizationEntries == null || this.realizationEntries.size() == 0) {
                throw new IllegalArgumentException();
            }
            RealizationRegistry registry = RealizationRegistry.getInstance(this.config);
            ArrayList realizationList = Lists.newArrayList();
            for (int i = 0; i < this.realizationEntries.size(); ++i) {
                IRealization realization = registry.getRealization(this.realizationEntries.get(i).getType(), this.realizationEntries.get(i).getRealization());
                if (realization == null) {
                    logger.error("Realization '" + this.realizationEntries.get(i) + " is not found, remove from Hybrid '" + this.getName() + "'");
                    continue;
                }
                if (!realization.isReady()) {
                    logger.error("Realization '" + realization.getName() + " is disabled, remove from Hybrid '" + this.getName() + "'");
                    continue;
                }
                realizationList.add(realization);
            }
            LinkedHashSet<TblColRef> columns = new LinkedHashSet<TblColRef>();
            LinkedHashSet<TblColRef> dimensions = new LinkedHashSet<TblColRef>();
            LinkedHashSet<MeasureDesc> measures = new LinkedHashSet<MeasureDesc>();
            this.dateRangeStart = 0L;
            this.dateRangeEnd = Long.MAX_VALUE;
            for (IRealization realization : realizationList) {
                columns.addAll(realization.getAllColumns());
                dimensions.addAll(realization.getAllDimensions());
                measures.addAll(realization.getMeasures());
                if (realization.isReady()) {
                    this.isReady = true;
                }
                if (this.dateRangeStart == 0L || realization.getDateRangeStart() < this.dateRangeStart) {
                    this.dateRangeStart = realization.getDateRangeStart();
                }
                if (this.dateRangeStart != Long.MAX_VALUE && realization.getDateRangeEnd() <= this.dateRangeEnd) continue;
                this.dateRangeEnd = realization.getDateRangeEnd();
            }
            this.allDimensions = Lists.newArrayList(dimensions);
            this.allColumns = Lists.newArrayList(columns);
            this.allMeasures = Lists.newArrayList(measures);
            Collections.sort(realizationList, new Comparator<IRealization>(){

                @Override
                public int compare(IRealization o1, IRealization o2) {
                    long i2;
                    long i1 = o1.getDateRangeStart();
                    long comp = i1 - (i2 = o2.getDateRangeStart());
                    if (comp != 0L) {
                        return comp > 0L ? 1 : -1;
                    }
                    i1 = o1.getDateRangeEnd();
                    comp = i1 - (i2 = o2.getDateRangeEnd());
                    if (comp != 0L) {
                        return comp > 0L ? 1 : -1;
                    }
                    return 0;
                }
            });
            this.realizations = realizationList.toArray(new IRealization[realizationList.size()]);
        }
    }

    @Override
    public CapabilityResult isCapable(SQLDigest digest) {
        CapabilityResult result = new CapabilityResult();
        result.cost = Integer.MAX_VALUE;
        for (IRealization realization : this.getRealizations()) {
            CapabilityResult child = realization.isCapable(digest);
            if (!child.capable) continue;
            result.capable = true;
            result.cost = Math.min(result.cost, child.cost);
            result.influences.addAll(child.influences);
        }
        if (result.cost > 0) {
            --result.cost;
        }
        return result;
    }

    @Override
    public RealizationType getType() {
        return RealizationType.HYBRID;
    }

    @Override
    public DataModelDesc getDataModelDesc() {
        if (this.getLatestRealization() != null) {
            return this.getLatestRealization().getDataModelDesc();
        }
        return null;
    }

    @Override
    public String getFactTable() {
        return this.getRealizations()[0].getFactTable();
    }

    @Override
    public List<TblColRef> getAllColumns() {
        this.init();
        return this.allColumns;
    }

    @Override
    public List<MeasureDesc> getMeasures() {
        this.init();
        return this.allMeasures;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    @Override
    public String getCanonicalName() {
        return (Object)((Object)this.getType()) + "[name=" + this.name + "]";
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public void setConfig(KylinConfig config) {
        this.config = config;
    }

    @Override
    public long getDateRangeStart() {
        return this.dateRangeStart;
    }

    @Override
    public long getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    @Override
    public String getModelName() {
        return this.getLatestRealization().getModelName();
    }

    @Override
    public List<TblColRef> getAllDimensions() {
        this.init();
        return this.allDimensions;
    }

    public IRealization[] getRealizations() {
        this.init();
        return this.realizations;
    }

    public String getResourcePath() {
        return HybridInstance.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String hybridName) {
        return "/hybrid/" + hybridName + ".json";
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public IRealization getLatestRealization() {
        if (this.getRealizations().length > 0) {
            return this.realizations[this.realizations.length - 1];
        }
        return null;
    }

    @Override
    public int getStorageType() {
        return 1;
    }
}

