/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.manager.ExecutableManager;
import org.apache.kylin.storage.hbase.util.HiveCmdBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanupJob
extends AbstractHadoopJob {
    private static final Option OPTION_DELETE;
    protected static final Logger logger;
    public static final long TIME_THREADSHOLD = 172800000L;
    boolean delete = false;
    protected static ExecutableManager executableManager;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        logger.info("jobs args: " + Arrays.toString(args));
        try {
            options.addOption(OPTION_DELETE);
            this.parseOptions(options, args);
            logger.info("options: '" + this.getOptionsAsString() + "'");
            logger.info("delete option value: '" + this.getOptionValue(OPTION_DELETE) + "'");
            this.delete = Boolean.parseBoolean(this.getOptionValue(OPTION_DELETE));
            Configuration conf = HBaseConfiguration.create((Configuration)this.getConf());
            this.cleanUnusedIntermediateHiveTable(conf);
            this.cleanUnusedHdfsFiles(conf);
            this.cleanUnusedHBaseTables(conf);
            return 0;
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    private void cleanUnusedHBaseTables(Configuration conf) throws IOException {
        String tablename;
        CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        IIManager iiManager = IIManager.getInstance(KylinConfig.getInstanceFromEnv());
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        String tableNamePrefix = "KYLIN_";
        HTableDescriptor[] tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*");
        ArrayList<String> allTablesNeedToBeDropped = new ArrayList<String>();
        for (HTableDescriptor hTableDescriptor : tableDescriptors) {
            String host = hTableDescriptor.getValue("KYLIN_HOST");
            String creationTime = hTableDescriptor.getValue("CREATION_TIME");
            if (!KylinConfig.getInstanceFromEnv().getMetadataUrlPrefix().equalsIgnoreCase(host)) continue;
            if (StringUtils.isEmpty((String)creationTime) || System.currentTimeMillis() - Long.valueOf(creationTime) > 172800000L) {
                allTablesNeedToBeDropped.add(hTableDescriptor.getTableName().getNameAsString());
                continue;
            }
            logger.info("Exclude table " + hTableDescriptor.getTableName().getNameAsString() + " from drop list, as it is newly created");
        }
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            for (CubeSegment cubeSegment : cube.getSegments()) {
                tablename = cubeSegment.getStorageLocationIdentifier();
                if (!allTablesNeedToBeDropped.contains(tablename)) continue;
                allTablesNeedToBeDropped.remove(tablename);
                logger.info("Exclude table " + tablename + " from drop list, as the table belongs to cube " + cube.getName() + " with status " + (Object)((Object)cube.getStatus()));
            }
        }
        for (IIInstance ii : iiManager.listAllIIs()) {
            for (IISegment iISegment : ii.getSegments()) {
                tablename = iISegment.getStorageLocationIdentifier();
                if (!allTablesNeedToBeDropped.contains(tablename)) continue;
                allTablesNeedToBeDropped.remove(tablename);
                logger.info("Exclude table " + tablename + " from drop list, as the table belongs to ii " + ii.getName() + " with status " + (Object)((Object)ii.getStatus()));
            }
        }
        if (this.delete) {
            for (String htableName : allTablesNeedToBeDropped) {
                logger.info("Deleting HBase table " + htableName);
                if (hbaseAdmin.tableExists(htableName)) {
                    if (hbaseAdmin.isTableEnabled(htableName)) {
                        hbaseAdmin.disableTable(htableName);
                    }
                    hbaseAdmin.deleteTable(htableName);
                    logger.info("Deleted HBase table " + htableName);
                    continue;
                }
                logger.info("HBase table" + htableName + " does not exist");
            }
        } else {
            System.out.println("--------------- Tables To Be Dropped ---------------");
            for (String htableName : allTablesNeedToBeDropped) {
                System.out.println(htableName);
            }
            System.out.println("----------------------------------------------------");
        }
        hbaseAdmin.close();
    }

    private void cleanUnusedHdfsFiles(Configuration conf) throws IOException {
        String path;
        FileStatus[] fStatus;
        JobEngineConfig engineConfig = new JobEngineConfig(KylinConfig.getInstanceFromEnv());
        CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        FileSystem fs = FileSystem.get((Configuration)conf);
        ArrayList<String> allHdfsPathsNeedToBeDeleted = new ArrayList<String>();
        for (FileStatus status : fStatus = fs.listStatus(new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory()))) {
            path = status.getPath().getName();
            if (!path.startsWith("kylin-")) continue;
            String kylinJobPath = engineConfig.getHdfsWorkingDirectory() + path;
            allHdfsPathsNeedToBeDeleted.add(kylinJobPath);
        }
        List<String> allJobs = executableManager.getAllJobIds();
        for (String jobId : allJobs) {
            ExecutableState state = executableManager.getOutput(jobId).getState();
            if (state.isFinalState()) continue;
            path = JobInstance.getJobWorkingDir(jobId, engineConfig.getHdfsWorkingDirectory());
            allHdfsPathsNeedToBeDeleted.remove(path);
            logger.info("Remove " + path + " from deletion list, as the path belongs to job " + jobId + " with status " + (Object)((Object)state));
        }
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            for (CubeSegment seg : cube.getSegments()) {
                String jobUuid = seg.getLastBuildJobID();
                if (jobUuid == null || jobUuid.equals("")) continue;
                String path2 = JobInstance.getJobWorkingDir(jobUuid, engineConfig.getHdfsWorkingDirectory());
                allHdfsPathsNeedToBeDeleted.remove(path2);
                logger.info("Remove " + path2 + " from deletion list, as the path belongs to segment " + seg + " of cube " + cube.getName());
            }
        }
        if (this.delete) {
            for (String hdfsPath : allHdfsPathsNeedToBeDeleted) {
                logger.info("Deleting hdfs path " + hdfsPath);
                Path p = new Path(hdfsPath);
                if (fs.exists(p)) {
                    fs.delete(p, true);
                    logger.info("Deleted hdfs path " + hdfsPath);
                    continue;
                }
                logger.info("Hdfs path " + hdfsPath + "does not exist");
            }
        } else {
            System.out.println("--------------- HDFS Path To Be Deleted ---------------");
            for (String hdfsPath : allHdfsPathsNeedToBeDeleted) {
                System.out.println(hdfsPath);
            }
            System.out.println("-------------------------------------------------------");
        }
    }

    private void cleanUnusedIntermediateHiveTable(Configuration conf) throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CliCommandExecutor cmdExec = config.getCliCommandExecutor();
        int uuidLength = 36;
        String useDatabaseHql = "USE " + config.getHiveDatabaseForIntermediateTable() + ";";
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(useDatabaseHql);
        hiveCmdBuilder.addStatement("show tables 'kylin_intermediate_*'; ");
        Pair<Integer, String> result = cmdExec.execute(hiveCmdBuilder.build());
        String outputStr = result.getSecond();
        BufferedReader reader = new BufferedReader(new StringReader(outputStr));
        String line = null;
        List<String> allJobs = executableManager.getAllJobIds();
        ArrayList<String> allHiveTablesNeedToBeDeleted = new ArrayList<String>();
        ArrayList<String> workingJobList = new ArrayList<String>();
        for (String jobId : allJobs) {
            ExecutableState state = executableManager.getOutput(jobId).getState();
            if (state.isFinalState()) continue;
            workingJobList.add(jobId);
            logger.info("Remove intermediate hive table with job id " + jobId + " with job status " + (Object)((Object)state));
        }
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("kylin_intermediate_")) continue;
            boolean isNeedDel = false;
            String uuid = line.substring(line.length() - 36, line.length());
            if (allJobs.contains(uuid = uuid.replace("_", "-")) && !workingJobList.contains(uuid)) {
                isNeedDel = true;
            }
            if (!isNeedDel) continue;
            allHiveTablesNeedToBeDeleted.add(line);
        }
        if (this.delete) {
            hiveCmdBuilder.reset();
            hiveCmdBuilder.addStatement(useDatabaseHql);
            for (String delHive : allHiveTablesNeedToBeDeleted) {
                hiveCmdBuilder.addStatement("drop table if exists " + delHive + "; ");
                logger.info("Remove " + delHive + " from hive tables.");
            }
            try {
                cmdExec.execute(hiveCmdBuilder.build());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("------ Intermediate Hive Tables To Be Dropped ------");
            for (String hiveTable : allHiveTablesNeedToBeDeleted) {
                System.out.println(hiveTable);
            }
            System.out.println("----------------------------------------------------");
        }
        if (reader != null) {
            reader.close();
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new StorageCleanupJob(), (String[])args);
        System.exit(exitCode);
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused storage");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        logger = LoggerFactory.getLogger(StorageCleanupJob.class);
        executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
    }
}

