/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCmdBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HiveCmdBuilder.class);
    private HiveClientMode clientMode;
    private KylinConfig kylinConfig;
    private final ArrayList<String> statements = Lists.newArrayList();

    public HiveCmdBuilder() {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.clientMode = HiveClientMode.valueOf(this.kylinConfig.getHiveClientMode().toUpperCase());
    }

    public String build() {
        StringBuffer buf = new StringBuffer();
        switch (this.clientMode) {
            case CLI: {
                buf.append("hive -e \"");
                for (String statement : this.statements) {
                    buf.append(statement).append("\n");
                }
                buf.append("\"");
                break;
            }
            case BEELINE: {
                BufferedWriter bw = null;
                try {
                    File tmpHql = File.createTempFile("beeline_", ".hql");
                    StringBuffer hqlBuf = new StringBuffer();
                    bw = new BufferedWriter(new FileWriter(tmpHql));
                    for (String statement : this.statements) {
                        bw.write(statement);
                        bw.newLine();
                        hqlBuf.append(statement).append("\n");
                    }
                    buf.append("beeline ");
                    buf.append(this.kylinConfig.getHiveBeelineParams());
                    buf.append(" -f ");
                    buf.append(tmpHql.getAbsolutePath());
                    buf.append(";rm -f ");
                    buf.append(tmpHql.getAbsolutePath());
                    logger.info("The statements to execute in beeline: \n" + hqlBuf);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bw);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)bw);
                break;
            }
            default: {
                throw new RuntimeException("Hive client cannot be recognized: " + (Object)((Object)this.clientMode));
            }
        }
        return buf.toString();
    }

    public void reset() {
        this.statements.clear();
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public String toString() {
        return this.build();
    }

    public static enum HiveClientMode {
        CLI,
        BEELINE;

    }
}

