/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii.coprocessor.endpoint;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.kylin.invertedindex.model.IIRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseServerKVIterator
implements Iterable<IIRow>,
Closeable {
    private RegionScanner innerScanner;
    private Logger logger = LoggerFactory.getLogger(HbaseServerKVIterator.class);

    public HbaseServerKVIterator(RegionScanner innerScanner) {
        this.innerScanner = innerScanner;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.innerScanner);
    }

    @Override
    public Iterator<IIRow> iterator() {
        return new IIRowIterator(this.innerScanner);
    }

    private static class IIRowIterator
    implements Iterator<IIRow> {
        private final RegionScanner regionScanner;
        private final IIRow row = new IIRow();
        List<Cell> results = Lists.newArrayList();
        private boolean hasMore;

        IIRowIterator(RegionScanner innerScanner) {
            this.regionScanner = innerScanner;
            try {
                this.hasMore = this.regionScanner.nextRaw(this.results);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.results.isEmpty();
        }

        @Override
        public IIRow next() {
            if (this.results.size() < 1) {
                throw new NoSuchElementException();
            }
            for (Cell c : this.results) {
                this.row.updateWith(c);
            }
            this.results.clear();
            try {
                if (this.hasMore) {
                    this.hasMore = this.regionScanner.nextRaw(this.results);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.row;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

