/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii.coprocessor.endpoint;

import java.util.List;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;

public class EndpointTupleConverter {
    final TupleInfo tupleInfo;
    final List<TblColRef> columns;
    final int[] columnTupleIdx;
    final int[] aggrTupleIdx;

    public EndpointTupleConverter(List<TblColRef> columns, List<FunctionDesc> aggrMeasures, TupleInfo returnTupleInfo) {
        int i;
        this.tupleInfo = returnTupleInfo;
        this.columns = columns;
        this.columnTupleIdx = new int[columns.size()];
        this.aggrTupleIdx = new int[aggrMeasures.size()];
        for (i = 0; i < columns.size(); ++i) {
            TblColRef col = columns.get(i);
            this.columnTupleIdx[i] = this.tupleInfo.hasColumn(col) ? this.tupleInfo.getColumnIndex(col) : -1;
        }
        for (i = 0; i < aggrMeasures.size(); ++i) {
            TblColRef col;
            String rewriteFieldName;
            FunctionDesc measure = aggrMeasures.get(i);
            int tupleIdx = measure.isDimensionAsMetric() ? -1 : (measure.needRewrite() ? (this.tupleInfo.hasField(rewriteFieldName = measure.getRewriteFieldName()) ? this.tupleInfo.getFieldIndex(rewriteFieldName) : -1) : (this.tupleInfo.hasColumn(col = measure.getParameter().getColRefs().get(0)) ? this.tupleInfo.getColumnIndex(col) : -1));
            this.aggrTupleIdx[i] = tupleIdx;
        }
    }

    public ITuple makeTuple(TableRecord tableRecord, List<Object> measureValues, Tuple tuple) {
        Object value;
        int tupleIdx;
        int i;
        for (i = 0; i < this.columnTupleIdx.length; ++i) {
            tupleIdx = this.columnTupleIdx[i];
            if (tupleIdx < 0) continue;
            value = tableRecord.getValueString(i);
            tuple.setDimensionValue(tupleIdx, (String)value);
        }
        if (measureValues != null) {
            for (i = 0; i < this.aggrTupleIdx.length; ++i) {
                tupleIdx = this.aggrTupleIdx[i];
                if (tupleIdx < 0) continue;
                value = measureValues.get(i);
                if (value instanceof String) {
                    String dataType = tuple.getDataTypeName(tupleIdx);
                    value = Tuple.convertOptiqCellValue((String)value, dataType);
                }
                tuple.setMeasureValue(tupleIdx, value);
            }
        }
        return tuple;
    }
}

