/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii.coprocessor.endpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.invertedindex.index.RawTableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.hllc.HLLCMeasureType;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.LongMutable;
import org.apache.kylin.metadata.model.FunctionDesc;

public class EndpointAggregators {
    final String[] funcNames;
    final String[] dataTypes;
    final MetricInfo[] metricInfos;
    final transient TableRecordInfoDigest tableRecordInfoDigest;
    final transient RawTableRecord rawTableRecord;
    final transient ImmutableBytesWritable byteBuffer;
    final transient HyperLogLogPlusCounter[] hllcs;
    final transient FixedLenMeasureCodec[] measureSerializers;
    final transient Object[] metricValues;
    final LongMutable ONE = new LongMutable(1L);
    private static final BytesSerializer<EndpointAggregators> serializer = new BytesSerializer<EndpointAggregators>(){

        @Override
        public void serialize(EndpointAggregators value, ByteBuffer out) {
            BytesUtil.writeAsciiStringArray(value.funcNames, out);
            BytesUtil.writeAsciiStringArray(value.dataTypes, out);
            BytesUtil.writeVInt(value.metricInfos.length, out);
            for (int i = 0; i < value.metricInfos.length; ++i) {
                MetricInfo metricInfo = value.metricInfos[i];
                BytesUtil.writeAsciiString(metricInfo.type.toString(), out);
                BytesUtil.writeVInt(metricInfo.refIndex, out);
                BytesUtil.writeVInt(metricInfo.precision, out);
            }
            BytesUtil.writeByteArray(TableRecordInfoDigest.serialize(value.tableRecordInfoDigest), out);
        }

        @Override
        public EndpointAggregators deserialize(ByteBuffer in) {
            String[] funcNames = BytesUtil.readAsciiStringArray(in);
            String[] dataTypes = BytesUtil.readAsciiStringArray(in);
            int metricInfoLength = BytesUtil.readVInt(in);
            MetricInfo[] infos = new MetricInfo[metricInfoLength];
            for (int i = 0; i < infos.length; ++i) {
                MetricType type = MetricType.valueOf(BytesUtil.readAsciiString(in));
                int refIndex = BytesUtil.readVInt(in);
                int presision = BytesUtil.readVInt(in);
                infos[i] = new MetricInfo(type, refIndex, presision);
            }
            byte[] temp = BytesUtil.readByteArray(in);
            TableRecordInfoDigest tableInfo = TableRecordInfoDigest.deserialize(temp);
            return new EndpointAggregators(funcNames, dataTypes, infos, tableInfo);
        }
    };

    private static MetricInfo generateMetricInfo(TableRecordInfo tableInfo, FunctionDesc functionDesc) {
        if (functionDesc.isCount()) {
            return new MetricInfo(MetricType.Count);
        }
        if (functionDesc.isDimensionAsMetric()) {
            return new MetricInfo(MetricType.DimensionAsMetric);
        }
        int index = tableInfo.findFactTableColumn(functionDesc.getParameter().getValue());
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (Object)("Column " + functionDesc.getParameter().getValue() + " is not found in II"));
        if (HLLCMeasureType.isCountDistinct(functionDesc)) {
            return new MetricInfo(MetricType.DistinctCount, index, functionDesc.getReturnDataType().getPrecision());
        }
        return new MetricInfo(MetricType.Normal, index);
    }

    public static EndpointAggregators fromFunctions(TableRecordInfo tableInfo, List<FunctionDesc> metrics) {
        int metricSize = metrics.size();
        String[] funcNames = new String[metricSize];
        String[] dataTypes = new String[metricSize];
        MetricInfo[] metricInfos = new MetricInfo[metricSize];
        for (int i = 0; i < metricSize; ++i) {
            FunctionDesc functionDesc = metrics.get(i);
            funcNames[i] = functionDesc.getExpression();
            dataTypes[i] = functionDesc.getReturnType();
            metricInfos[i] = EndpointAggregators.generateMetricInfo(tableInfo, functionDesc);
        }
        return new EndpointAggregators(funcNames, dataTypes, metricInfos, tableInfo.getDigest());
    }

    private EndpointAggregators(String[] funcNames, String[] dataTypes, MetricInfo[] metricInfos, TableRecordInfoDigest tableInfo) {
        this.funcNames = funcNames;
        this.dataTypes = dataTypes;
        this.metricInfos = metricInfos;
        this.tableRecordInfoDigest = tableInfo;
        this.rawTableRecord = tableInfo.createTableRecordBytes();
        this.byteBuffer = new ImmutableBytesWritable();
        this.hllcs = new HyperLogLogPlusCounter[this.metricInfos.length];
        this.metricValues = new Object[funcNames.length];
        this.measureSerializers = new FixedLenMeasureCodec[funcNames.length];
        for (int i = 0; i < this.measureSerializers.length; ++i) {
            this.measureSerializers[i] = FixedLenMeasureCodec.get(DataType.getType(dataTypes[i]));
        }
    }

    public TableRecordInfoDigest getTableRecordInfoDigest() {
        return this.tableRecordInfoDigest;
    }

    public boolean isEmpty() {
        return this.funcNames == null || this.funcNames.length == 0;
    }

    public MeasureAggregator[] createBuffer() {
        MeasureAggregator[] aggrs = new MeasureAggregator[this.funcNames.length];
        for (int i = 0; i < aggrs.length; ++i) {
            aggrs[i] = this.metricInfos[i].type == MetricType.DistinctCount ? MeasureAggregator.create(this.funcNames[i], DataType.getType(this.dataTypes[i])) : MeasureAggregator.create(this.funcNames[i], DataType.getType("long"));
        }
        return aggrs;
    }

    public void aggregate(MeasureAggregator[] measureAggrs, byte[] row) {
        this.rawTableRecord.setBytes(row, 0, row.length);
        for (int metricIndex = 0; metricIndex < this.metricInfos.length; ++metricIndex) {
            MetricInfo metricInfo = this.metricInfos[metricIndex];
            if (metricInfo.type == MetricType.Count) {
                measureAggrs[metricIndex].aggregate(this.ONE);
                continue;
            }
            if (metricInfo.type == MetricType.DimensionAsMetric) continue;
            MeasureAggregator aggregator = measureAggrs[metricIndex];
            FixedLenMeasureCodec measureSerializer = this.measureSerializers[metricIndex];
            this.rawTableRecord.getValueBytes(metricInfo.refIndex, this.byteBuffer);
            if (metricInfo.type == MetricType.Normal) {
                aggregator.aggregate(measureSerializer.read(this.byteBuffer.get(), this.byteBuffer.getOffset()));
                continue;
            }
            if (metricInfo.type != MetricType.DistinctCount) continue;
            HyperLogLogPlusCounter hllc = this.hllcs[metricIndex];
            if (hllc == null) {
                int precision = metricInfo.precision;
                hllc = new HyperLogLogPlusCounter(precision);
            }
            hllc.clear();
            hllc.add(this.byteBuffer.get(), this.byteBuffer.getOffset(), this.byteBuffer.getLength());
            aggregator.aggregate(hllc);
        }
    }

    public int serializeMetricValues(MeasureAggregator[] aggrs, byte[] buffer, int offset) {
        for (int i = 0; i < this.funcNames.length; ++i) {
            this.metricValues[i] = aggrs[i].getState();
        }
        int metricBytesOffset = offset;
        int length = 0;
        for (int i = 0; i < this.measureSerializers.length; ++i) {
            this.measureSerializers[i].write(this.metricValues[i], buffer, metricBytesOffset);
            metricBytesOffset += this.measureSerializers[i].getLength();
            length += this.measureSerializers[i].getLength();
        }
        return length;
    }

    public List<Object> deserializeMetricValues(ByteBuffer buffer) {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < this.measureSerializers.length; ++i) {
            this.measureSerializers[i].read(buffer);
            Object valueString = this.measureSerializers[i].getValue();
            ret.add(valueString);
        }
        return ret;
    }

    public static byte[] serialize(EndpointAggregators o) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        serializer.serialize(o, buf);
        byte[] result = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, result, 0, buf.position());
        return result;
    }

    public static EndpointAggregators deserialize(byte[] bytes) {
        return serializer.deserialize(ByteBuffer.wrap(bytes));
    }

    public int getMeasureSerializeLength() {
        int length = 0;
        for (int i = 0; i < this.measureSerializers.length; ++i) {
            length += this.measureSerializers[i].getLength();
        }
        return length;
    }

    private static final class MetricInfo {
        private MetricType type;
        private int refIndex = -1;
        private int precision = -1;

        public MetricInfo(MetricType type, int refIndex, int precision) {
            this.type = type;
            this.refIndex = refIndex;
            this.precision = precision;
        }

        public MetricInfo(MetricType type, int refIndex) {
            this.type = type;
            this.refIndex = refIndex;
        }

        public MetricInfo(MetricType type) {
            this.type = type;
        }
    }

    private static enum MetricType {
        Count,
        DimensionAsMetric,
        DistinctCount,
        Normal;

    }
}

