/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii;

import java.util.ArrayList;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.ii.coprocessor.endpoint.EndpointTupleIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexStorageQuery
implements IStorageQuery {
    private static Logger logger = LoggerFactory.getLogger(InvertedIndexStorageQuery.class);
    private IISegment seg;
    private String uuid;
    private EndpointTupleIterator dataIterator;

    public InvertedIndexStorageQuery(IIInstance ii) {
        this.seg = ii.getFirstSegment();
        this.uuid = ii.getUuid();
    }

    @Override
    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        String tableName = this.seg.getStorageLocationIdentifier();
        HConnection conn = HBaseConnection.get(context.getConnUrl());
        try {
            this.dataIterator = new EndpointTupleIterator(this.seg, sqlDigest.filter, sqlDigest.groupbyColumns, new ArrayList<FunctionDesc>(sqlDigest.aggregations), context, conn, returnTupleInfo);
            return this.dataIterator;
        }
        catch (Throwable e) {
            logger.error("Error when connecting to II htable " + tableName, e);
            throw new IllegalStateException("Error when connecting to II htable " + tableName, e);
        }
    }
}

