/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.invertedindex.model.IIDesc;

public class IICreateHFileMapper
extends KylinMapper<ImmutableBytesWritable, ImmutableBytesWritable, ImmutableBytesWritable, KeyValue> {
    long timestamp;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.timestamp = System.currentTimeMillis();
    }

    protected void map(ImmutableBytesWritable key, ImmutableBytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
        ByteBuffer buffer = ByteBuffer.wrap(value.get(), value.getOffset(), value.getLength());
        int totalLength = value.getLength();
        int valueLength = buffer.getInt();
        int dictionaryLength = totalLength - valueLength - 4;
        KeyValue kv = new KeyValue(key.get(), key.getOffset(), key.getLength(), IIDesc.HBASE_FAMILY_BYTES, 0, IIDesc.HBASE_FAMILY_BYTES.length, IIDesc.HBASE_QUALIFIER_BYTES, 0, IIDesc.HBASE_QUALIFIER_BYTES.length, this.timestamp, KeyValue.Type.Put, buffer.array(), buffer.position(), valueLength);
        context.write((Object)key, (Object)kv);
        kv = new KeyValue(key.get(), key.getOffset(), key.getLength(), IIDesc.HBASE_FAMILY_BYTES, 0, IIDesc.HBASE_FAMILY_BYTES.length, IIDesc.HBASE_DICTIONARY_BYTES, 0, IIDesc.HBASE_DICTIONARY_BYTES.length, this.timestamp, KeyValue.Type.Put, buffer.array(), buffer.position() + valueLength, dictionaryLength);
        context.write((Object)key, (Object)kv);
    }
}

