/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii;

import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.ii.IICreateHFileMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IICreateHFileJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(IICreateHFileJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_II_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_HTABLE_NAME);
            this.parseOptions(options, args);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.setJobClasspath(this.job);
            IICreateHFileJob.addInputDirs(this.getOptionValue(OPTION_INPUT_PATH), this.job);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(IICreateHFileMapper.class);
            this.job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            this.job.setMapOutputValueClass(KeyValue.class);
            String tableName = this.getOptionValue(OPTION_HTABLE_NAME);
            HTable htable = new HTable(HBaseConfiguration.create((Configuration)this.getConf()), tableName);
            HFileOutputFormat.configureIncrementalLoad((Job)this.job, (HTable)htable);
            this.deletePath(this.job.getConfiguration(), output);
            return this.waitForCompletion(this.job);
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }
}

