/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hbase.cube.v2.CubeSegmentScanner;
import org.apache.kylin.storage.hbase.cube.v2.CubeTupleConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialCubeTupleIterator
implements ITupleIterator {
    private static final Logger logger = LoggerFactory.getLogger(SequentialCubeTupleIterator.class);
    protected final Cuboid cuboid;
    protected final Set<TblColRef> selectedDimensions;
    protected final Set<FunctionDesc> selectedMetrics;
    protected final TupleInfo tupleInfo;
    protected final Tuple tuple;
    protected final Iterator<CubeSegmentScanner> scannerIterator;
    protected final StorageContext context;
    protected CubeSegmentScanner curScanner;
    protected Iterator<GTRecord> curRecordIterator;
    protected CubeTupleConverter curTupleConverter;
    protected Tuple next;
    private List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    private int advMeasureRowsRemaining;
    private int advMeasureRowIndex;
    private int scanCount;
    private int scanCountDelta;

    public SequentialCubeTupleIterator(List<CubeSegmentScanner> scanners, Cuboid cuboid, Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics, TupleInfo returnTupleInfo, StorageContext context) {
        this.cuboid = cuboid;
        this.selectedDimensions = selectedDimensions;
        this.selectedMetrics = selectedMetrics;
        this.tupleInfo = returnTupleInfo;
        this.tuple = new Tuple(returnTupleInfo);
        this.scannerIterator = scanners.iterator();
        this.context = context;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.advMeasureRowsRemaining > 0) {
            for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
                filler.fillTuple(this.tuple, this.advMeasureRowIndex);
            }
            ++this.advMeasureRowIndex;
            --this.advMeasureRowsRemaining;
            this.next = this.tuple;
            return true;
        }
        if (this.curScanner == null) {
            if (this.scannerIterator.hasNext()) {
                this.curScanner = this.scannerIterator.next();
                this.curRecordIterator = this.curScanner.iterator();
                if (this.curRecordIterator.hasNext()) {
                    this.curTupleConverter = new CubeTupleConverter(this.curScanner.cubeSeg, this.cuboid, this.selectedDimensions, this.selectedMetrics, this.tupleInfo);
                }
            } else {
                return false;
            }
        }
        if (!this.curRecordIterator.hasNext()) {
            this.close(this.curScanner);
            this.curScanner = null;
            this.curRecordIterator = null;
            this.curTupleConverter = null;
            return this.hasNext();
        }
        GTRecord curRecord = this.curRecordIterator.next();
        this.advMeasureFillers = this.curTupleConverter.translateResult(curRecord, this.tuple);
        if (this.advMeasureFillers == null) {
            this.next = this.tuple;
            return true;
        }
        this.advMeasureRowsRemaining = -1;
        for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
            if (this.advMeasureRowsRemaining < 0) {
                this.advMeasureRowsRemaining = filler.getNumOfRows();
            }
            if (this.advMeasureRowsRemaining == filler.getNumOfRows()) continue;
            throw new IllegalStateException();
        }
        if (this.advMeasureRowsRemaining < 0) {
            throw new IllegalStateException();
        }
        this.advMeasureRowIndex = 0;
        return this.hasNext();
    }

    @Override
    public ITuple next() {
        if (this.next == null) {
            this.hasNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        ++this.scanCount;
        if (++this.scanCountDelta >= 1000) {
            this.flushScanCountDelta();
        }
        Tuple result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.flushScanCountDelta();
        if (this.curScanner != null) {
            this.close(this.curScanner);
        }
        while (this.scannerIterator.hasNext()) {
            this.close(this.scannerIterator.next());
        }
    }

    protected void close(CubeSegmentScanner scanner) {
        try {
            scanner.close();
        }
        catch (IOException e) {
            logger.error("Exception when close CubeScanner", (Throwable)e);
        }
    }

    public int getScanCount() {
        return this.scanCount;
    }

    private void flushScanCountDelta() {
        this.context.increaseTotalScanCount(this.scanCountDelta);
        this.scanCountDelta = 0;
    }
}

