/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;

public class ObserverTuple
implements IEvaluatableTuple {
    final CoprocessorRowType type;
    ImmutableBytesWritable rowkey;
    String[] values;

    public ObserverTuple(CoprocessorRowType type) {
        this.type = type;
        this.rowkey = new ImmutableBytesWritable();
        this.values = new String[type.getColumnCount()];
    }

    public void setUnderlying(byte[] array, int offset, int length) {
        this.rowkey.set(array, offset, length);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    private String getValueAt(int i) {
        int n = this.type.getColumnCount();
        if (i < 0 || i >= n) {
            return null;
        }
        if (this.values[i] == null) {
            this.values[i] = Dictionary.dictIdToString(this.rowkey.get(), this.rowkey.getOffset() + this.type.columnOffsets[i], this.type.columnSizes[i]);
        }
        return this.values[i];
    }

    @Override
    public Object getValue(TblColRef col) {
        int i = this.type.getColIndexByTblColRef(col);
        return this.getValueAt(i);
    }
}

