/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.invertedindex.model.IIRow;

public class HBaseClientKVIterator
implements Iterable<IIRow>,
Closeable {
    byte[] family;
    HTableInterface table;
    ResultScanner scanner;
    Iterator<Result> iterator;

    public HBaseClientKVIterator(HConnection hconn, String tableName, byte[] family) throws IOException {
        this.family = family;
        this.table = hconn.getTable(tableName);
        this.scanner = this.table.getScanner(family);
        this.iterator = this.scanner.iterator();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.scanner);
        IOUtils.closeQuietly((Closeable)this.table);
    }

    @Override
    public Iterator<IIRow> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<IIRow> {
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        ImmutableBytesWritable value = new ImmutableBytesWritable();
        ImmutableBytesWritable dict = new ImmutableBytesWritable();
        IIRow pair = new IIRow(this.key, this.value, this.dict);

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return HBaseClientKVIterator.this.iterator.hasNext();
        }

        @Override
        public IIRow next() {
            Result r = HBaseClientKVIterator.this.iterator.next();
            Cell c = r.getColumnLatestCell(IIDesc.HBASE_FAMILY_BYTES, IIDesc.HBASE_QUALIFIER_BYTES);
            this.key.set(c.getRowArray(), c.getRowOffset(), (int)c.getRowLength());
            this.value.set(c.getValueArray(), c.getValueOffset(), c.getValueLength());
            c = r.getColumnLatestCell(IIDesc.HBASE_FAMILY_BYTES, IIDesc.HBASE_DICTIONARY_BYTES);
            this.dict.set(c.getValueArray(), c.getValueOffset(), c.getValueLength());
            return this.pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

