/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.StorageException;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseConnection {
    public static final String HTABLE_UUID_TAG = "UUID";
    private static final Logger logger = LoggerFactory.getLogger(HBaseConnection.class);
    private static final Map<String, Configuration> ConfigCache = new ConcurrentHashMap<String, Configuration>();
    private static final Map<String, HConnection> ConnPool = new ConcurrentHashMap<String, HConnection>();
    private static final ThreadLocal<Configuration> hbaseConfig;

    public static void clearConnCache() {
        ConnPool.clear();
    }

    public static Configuration getCurrentHBaseConfiguration() {
        if (hbaseConfig.get() == null) {
            String storageUrl = KylinConfig.getInstanceFromEnv().getStorageUrl();
            hbaseConfig.set(HBaseConnection.newHBaseConfiguration(storageUrl));
        }
        return hbaseConfig.get();
    }

    private static Configuration newHBaseConfiguration(String url) {
        Configuration conf = HBaseConfiguration.create((Configuration)HadoopUtil.getCurrentConfiguration());
        if (!StringUtils.isEmpty((String)url) && !"hbase".equals(url)) {
            throw new IllegalArgumentException("to use hbase storage, pls set 'kylin.storage.url=hbase' in kylin.properties");
        }
        String hbaseClusterFs = KylinConfig.getInstanceFromEnv().getHBaseClusterFs();
        if (StringUtils.isNotEmpty((String)hbaseClusterFs)) {
            conf.set("fs.defaultFS", hbaseClusterFs);
        }
        if (StringUtils.isBlank((String)conf.get("hadoop.tmp.dir"))) {
            conf.set("hadoop.tmp.dir", "/tmp");
        }
        if (StringUtils.isBlank((String)conf.get("hbase.fs.tmp.dir"))) {
            conf.set("hbase.fs.tmp.dir", "/tmp");
        }
        conf.set(HConstants.HBASE_CLIENT_PAUSE, "3000");
        conf.set(HConstants.HBASE_CLIENT_RETRIES_NUMBER, "5");
        conf.set("hbase.client.operation.timeout", "60000");
        return conf;
    }

    public static String makeQualifiedPathInHBaseCluster(String path) {
        try {
            FileSystem fs = FileSystem.get((Configuration)HBaseConnection.getCurrentHBaseConfiguration());
            return fs.makeQualified(new Path(path)).toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create FileSystem from current hbase cluster conf", e);
        }
    }

    public static HConnection get(String url) {
        Configuration conf = ConfigCache.get(url);
        if (conf == null) {
            conf = HBaseConnection.newHBaseConfiguration(url);
            ConfigCache.put(url, conf);
        }
        HConnection connection = ConnPool.get(url);
        try {
            while (true) {
                if (connection == null || connection.isClosed()) {
                    logger.info("connection is null or closed, creating a new one");
                    connection = HConnectionManager.createConnection((Configuration)conf);
                    ConnPool.put(url, connection);
                }
                if (connection == null || connection.isClosed()) {
                    Thread.sleep(10000L);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            logger.error("Error when open connection " + url, t);
            throw new StorageException("Error when open connection " + url, t);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(HConnection conn, String tableName) throws IOException {
        try (HBaseAdmin hbase = new HBaseAdmin(conn);){
            boolean bl = hbase.tableExists(TableName.valueOf((String)tableName));
            return bl;
        }
    }

    public static boolean tableExists(String hbaseUrl, String tableName) throws IOException {
        return HBaseConnection.tableExists(HBaseConnection.get(hbaseUrl), tableName);
    }

    public static void createHTableIfNeeded(String hbaseUrl, String tableName, String ... families) throws IOException {
        HBaseConnection.createHTableIfNeeded(HBaseConnection.get(hbaseUrl), tableName, families);
    }

    public static void deleteTable(String hbaseUrl, String tableName) throws IOException {
        HBaseConnection.deleteTable(HBaseConnection.get(hbaseUrl), tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHTableIfNeeded(HConnection conn, String tableName, String ... families) throws IOException {
        try (HBaseAdmin hbase = new HBaseAdmin(conn);){
            if (HBaseConnection.tableExists(conn, tableName)) {
                logger.debug("HTable '" + tableName + "' already exists");
                return;
            }
            logger.debug("Creating HTable '" + tableName + "'");
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
            if (null != families && families.length > 0) {
                for (String family : families) {
                    HColumnDescriptor fd = new HColumnDescriptor(family);
                    fd.setInMemory(true);
                    desc.addFamily(fd);
                }
            }
            desc.setValue(HTABLE_UUID_TAG, UUID.randomUUID().toString());
            hbase.createTable(desc);
            logger.debug("HTable '" + tableName + "' created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTable(HConnection conn, String tableName) throws IOException {
        try (HBaseAdmin hbase = new HBaseAdmin(conn);){
            if (!HBaseConnection.tableExists(conn, tableName)) {
                logger.debug("HTable '" + tableName + "' does not exists");
                return;
            }
            logger.debug("delete HTable '" + tableName + "'");
            if (hbase.isTableEnabled(tableName)) {
                hbase.disableTable(tableName);
            }
            hbase.deleteTable(tableName);
            logger.debug("HTable '" + tableName + "' deleted");
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (HConnection conn : ConnPool.values()) {
                    try {
                        conn.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        hbaseConfig = new ThreadLocal();
    }
}

