/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source;

import java.util.HashMap;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ReadableTable;

public class SourceFactory {
    private static ImplementationSwitch<ISource> sources;

    public static ISource tableSource(ISourceAware aware) {
        return sources.get(aware.getSourceType());
    }

    public static ReadableTable createReadableTable(TableDesc table) {
        return SourceFactory.tableSource(table).createReadableTable(table);
    }

    public static <T> T createEngineAdapter(ISourceAware table, Class<T> engineInterface) {
        return SourceFactory.tableSource(table).adaptToBuildEngine(engineInterface);
    }

    static {
        HashMap<Integer, String> impls = new HashMap<Integer, String>();
        impls.put(0, "org.apache.kylin.source.hive.HiveSource");
        sources = new ImplementationSwitch<ISource>(impls, ISource.class);
    }
}

